/*
 * @(#)AsciiDef.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

/**
 * AsciiCodeDefineオブジェクト.
 * <BR><BR>
 * アスキーコード定義の定数情報をサポートします.
 *
 * @version 1.00, 2004/01/03
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class AsciiDef
{
    
    /**
     * アスキーコード情報.
     * <BR><BR>
     * アスキーコードの 0x00 -> 0xff までを
     * サポートする変換ケースです.
     * <BR>
     * ※また、改行情報はサポートしていません.
     */
    public static final String[] ASCII_CD = {
        
        // 0x00
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0x10
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0x20
        " ","!","\"","#","$","%","&","\'",
        "(",")","*","+",",","-",".","/",
        
        // 0x30
        "0","1","2","3","4","5","6","7",
        "8","9",":",";","<","=",">","?",
        
        // 0x40
        "@","A","B","C","D","E","F","G",
        "H","I","J","K","L","M","N","O",
        
        // 0x50
        "P","Q","R","S","T","U","V","W",
        "X","Y","Z","[","\\","]","^","_",
        
        // 0x60
        "`","a","b","c","d","e","f","g",
        "h","i","j","k","l","m","n","o",
        
        // 0x70
        "p","q","r","s","t","u","v","w",
        "x","y","z","{","|","}","~","",
        
        // 0x80
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0x90
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0xa0
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0xb0
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0xc0
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0xd0
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0xe0
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null,
        
        // 0xf0
        null,null,null,null,null,null,null,null,
        null,null,null,null,null,null,null,null
        
    } ;
    
    /**
     * 文字コードをアスキーコードに変換.
     * <BR><BR>
     * 変換コードをアスキーコードに変換します.
     * <BR>
     * @param code 対象のキャラクターコードを設定します.
     * @return int 変換されたアスキーコードが返されます.
     */
    public static final int convertCharByAscii( char code ){
        
        switch( code ){
            case ' ' :  return 0x00000020 ;
            case '!' :  return 0x00000021 ;
            case '\"' : return 0x00000022 ;
            case '#' :  return 0x00000023 ;
            case '$' :  return 0x00000024 ;
            case '%' :  return 0x00000025 ;
            case '&' :  return 0x00000026 ;
            case '\'' : return 0x00000027 ;
            case '(' :  return 0x00000028 ;
            case ')' :  return 0x00000029 ;
            case '*' :  return 0x0000002a ;
            case '+' :  return 0x0000002b ;
            case ',' :  return 0x0000002c ;
            case '-' :  return 0x0000002d ;
            case '.' :  return 0x0000002e ;
            case '/' :  return 0x0000002f ;
            case '0' :  return 0x00000030 ;
            case '1' :  return 0x00000031 ;
            case '2' :  return 0x00000032 ;
            case '3' :  return 0x00000033 ;
            case '4' :  return 0x00000034 ;
            case '5' :  return 0x00000035 ;
            case '6' :  return 0x00000036 ;
            case '7' :  return 0x00000037 ;
            case '8' :  return 0x00000038 ;
            case '9' :  return 0x00000039 ;
            case ':' :  return 0x0000003a ;
            case ';' :  return 0x0000003b ;
            case '<' :  return 0x0000003c ;
            case '=' :  return 0x0000003d ;
            case '>' :  return 0x0000003e ;
            case '?' :  return 0x0000003f ;
            case '@' :  return 0x00000040 ;
            case 'A' :  return 0x00000041 ;
            case 'B' :  return 0x00000042 ;
            case 'C' :  return 0x00000043 ;
            case 'D' :  return 0x00000044 ;
            case 'E' :  return 0x00000045 ;
            case 'F' :  return 0x00000046 ;
            case 'G' :  return 0x00000047 ;
            case 'H' :  return 0x00000048 ;
            case 'I' :  return 0x00000049 ;
            case 'J' :  return 0x0000004a ;
            case 'K' :  return 0x0000004b ;
            case 'L' :  return 0x0000004c ;
            case 'M' :  return 0x0000004d ;
            case 'N' :  return 0x0000004e ;
            case 'O' :  return 0x0000004f ;
            case 'P' :  return 0x00000050 ;
            case 'Q' :  return 0x00000051 ;
            case 'R' :  return 0x00000052 ;
            case 'S' :  return 0x00000053 ;
            case 'T' :  return 0x00000054 ;
            case 'U' :  return 0x00000055 ;
            case 'V' :  return 0x00000056 ;
            case 'W' :  return 0x00000057 ;
            case 'X' :  return 0x00000058 ;
            case 'Y' :  return 0x00000059 ;
            case 'Z' :  return 0x0000005a ;
            case '[' :  return 0x0000005b ;
            case '\\' : return 0x0000005c ;
            case ']' :  return 0x0000005d ;
            case '^' :  return 0x0000005e ;
            case '_' :  return 0x0000005f ;
            case '`' :  return 0x00000060 ;
            case 'a' :  return 0x00000061 ;
            case 'b' :  return 0x00000062 ;
            case 'c' :  return 0x00000063 ;
            case 'd' :  return 0x00000064 ;
            case 'e' :  return 0x00000065 ;
            case 'f' :  return 0x00000066 ;
            case 'g' :  return 0x00000067 ;
            case 'h' :  return 0x00000068 ;
            case 'i' :  return 0x00000069 ;
            case 'j' :  return 0x0000006a ;
            case 'k' :  return 0x0000006b ;
            case 'l' :  return 0x0000006c ;
            case 'm' :  return 0x0000006d ;
            case 'n' :  return 0x0000006e ;
            case 'o' :  return 0x0000006f ;
            case 'p' :  return 0x00000070 ;
            case 'q' :  return 0x00000071 ;
            case 'r' :  return 0x00000072 ;
            case 's' :  return 0x00000073 ;
            case 't' :  return 0x00000074 ;
            case 'u' :  return 0x00000075 ;
            case 'v' :  return 0x00000076 ;
            case 'w' :  return 0x00000077 ;
            case 'x' :  return 0x00000078 ;
            case 'y' :  return 0x00000079 ;
            case 'z' :  return 0x0000007a ;
            case '{' :  return 0x0000007b ;
            case '|' :  return 0x0000007c ;
            case '}' :  return 0x0000007d ;
            case '~' :  return 0x0000007e ;
            case '' :  return 0x0000007f ;
        }
        
        return 0xffffffff ;
    }
    
    /**
     * コンストラクタ.
     */
    private AsciiDef()
    {}
    
}

