/*
 * @(#)ThreadManPauseLocal.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.exception.InputException;

/**
 * スレッドローカル要素.
 *
 * @version     1.00, 2004/01/31
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
class ThreadStateLocal
{
    
    /** 
     * スレッド管理要素.
     */
    private ThreadState m_pause = null ;
    
    /**
     * コンストラクタ.
     */
    private ThreadStateLocal(){}
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 対象のスレッド名をThreadオブジェクトで設定します.
     * <BR>
     * @param thread 対象のスレッドオブジェクトを設定します.
     * @exception InputException 入力例外.
     */
    protected ThreadStateLocal( Thread thread )
        throws InputException
    {
        try{
            m_pause = new ThreadState( thread ) ;
        }catch( InputException in ){
            m_pause = null ;
            throw in ;
        }
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 対象のスレッドステータスオブジェクトを設定します.
     * <BR>
     * @param state 対象のスレッドステータスオブジェクトを設定します.
     * @exception InputException 入力例外.
     */
    protected ThreadStateLocal( ThreadState state )
        throws InputException
    {
        
        if( state == null ){
            throw new InputException( "引数が不正です" ) ;
        }
        
        m_pause = state ;
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        this.clear() ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public final void clear()
    {
        m_pause.clear() ;
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 情報を取得します.
     * <BR>
     * @return ThreadState スレッド管理１要素情報が返されます.
     */
    public final ThreadState get()
    {
        ThreadState ret = null ;
        
        synchronized( m_pause ){
            ret = m_pause ;
        }
            
        return ret ;
    }
    
}

