/*
 * @(#)ExecutionThread.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.exception.ExecutionException;

/**
 * スレッド実行処理定義.
 * <BR><BR>
 * スレッド実行処理定義をサポートします。
 * <BR>
 *
 * @version 1.0.0 2003/10/27
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
public abstract class ExecutionThread
{
    
    /**
     * スレッドステータス : 未設定.
     */
    public static final int STATE_NOT = -1 ;
    
    /**
     * スレッドステータス : スレッド生成.
     */
    public static final int STATE_CREATE = 0 ;
    
    /**
     * スレッドステータス : スレッド起動開始.
     */
    public static final int STATE_STARTUP = 1 ;
    
    /**
     * スレッドステータス : スレッド処理実施.
     */
    public static final int STATE_START = 2 ;
    
    /**
     * スレッドステータス : スレッド実施待ち.
     */
    public static final int STATE_WAIT_EXECUITON = 3 ;
    
    /**
     * スレッドステータス : スレッド実施.
     */
    public static final int STATE_EXECUTION = 4 ;
    
    /**
     * スレッドステータス文字変換.
     * <BR><BR>
     * スレッドステータス内容を文字列に変換します.
     * <BR>
     * @param state 対象のステータス情報を設定します.
     * @return String 変換された文字列が返されます.
     */
    public static final String getStateByName( int state )
    {
        String ret = null ;
        
        switch( state ){
            case ExecutionThread.STATE_NOT :
                ret = "not-thread" ;
                break ;
            case ExecutionThread.STATE_CREATE :
                ret = "create-thread" ;
                break ;
            case ExecutionThread.STATE_STARTUP :
                ret = "startup-thread" ;
                break ;
            case ExecutionThread.STATE_START :
                ret = "start-thread" ;
                break ;
            case ExecutionThread.STATE_WAIT_EXECUITON :
                ret = "wait-execution-thread" ;
                break ;
            case ExecutionThread.STATE_EXECUTION :
                ret = "execution-thread" ;
                break ;
            default :
                ret = "unknown-thread" ;
                break ;
        }
        
        return ret ;
    }
    
    
    
    /**
     * 実行初期化処理をサポートします.
     * <BR><BR>
     * 実行初期化処理をサポートします.<BR>
     * この処理は、スレッド処理が開始された時に呼び出されます.
     * <BR>
     * @param obj 実行開始時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected void init( Object obj )
        throws ExecutionException
    {
        // なし..
    }
    
    /**
     * 実行終了化処理をサポートします.
     * <BR><BR>
     * 実行終了化処理をサポートします.<BR>
     * この処理は、スレッド処理が終了された時に呼び出されます.
     * <BR>
     * @param obj 実行終了時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected void exit( Object obj )
        throws ExecutionException
    {
        // なし..
    }
    
    /**
     * ストップ処理をサポートします。
     * <BR><BR>
     * ストップ処理をサポートします。<BR>
     * この処理は、スレッドでのストップ処理に対して呼び出し実行されます.
     * <BR>
     * @param obj ストップ時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected void stop( Object obj )
        throws ExecutionException
    {
        // なし..
    }
    
    /**
     * 実行処理をサポートします。
     * <BR><BR>
     * 実行処理をサポートします。<BR>
     * この処理は、スレッドでの実行処理に対して呼び出し実行されます.
     * <BR>
     * @param obj 実行時に設定されます.
     * @exception ExecutionException 実行例外.
     */
    protected abstract void execution( Object obj )
        throws ExecutionException ;
    
    /**
     * 処理破棄時の処理をサポート。
     * <BR><BR>
     * 処理破棄時の処理をサポートします。<BR>
     * この処理は、スレッド破棄処理に対して呼び出し実行されます.
     * <BR>
     * @param obj スレッド破棄時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected void destroy( Object obj )
        throws ExecutionException
    {
        // なし..
    }
    
}
