/*
 * @(#)DeleteThreadException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.BaseException;

/**
 * スレッド削除検知例外.
 *  
 * @version 1.0.0 2003/10/24
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
public class DeleteThreadException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public DeleteThreadException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public DeleteThreadException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public DeleteThreadException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public DeleteThreadException(String message)
    {
        super(message) ;
    }
}
