/*
 * @(#)LoginException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.sys.user;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.BaseException;

/**
 * ログイン失敗例外.
 *  
 * @version 1.0.0 2005/09/18
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
public class LoginException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public LoginException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public LoginException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public LoginException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public LoginException(String message)
    {
        super(message) ;
    }
}
