/*
 * @(#)NoExitProcessException
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.sys.cmd;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.BaseException;

/**
 * プロセス実行中例外.
 * <BR><BR>
 * まだ、対象のプロセスが動作していることを示す例外です.
 *  
 * @version 1.0.0 2003/10/24
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
public class NoExitProcessException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public NoExitProcessException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NoExitProcessException(Throwable e)
    {
        super(e.getLocalizedMessage()) ;
        this.saveStackTrace(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NoExitProcessException(BaseException e)
    {
        super(e.getLocalizedMessage()) ;
        this.saveBaseStackTrace(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NoExitProcessException(String message)
    {
        super(message) ;
    }
}
