/*
 * @(#)Manager.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.sys;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.util.CharTable;

/**
 * マネージャ管理.
 * <BR><BR>
 * 情報を管理するマネージャオブジェクト.
 *  
 * @version 2006/07/16
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
public class Manager
{
    /**
     * データ管理オブジェクト.
     */
    private CharTable m_table = null ;
    
    /**
     * シングルトン.
     */
    private static final Manager SNGL = new Manager() ;
    
    /**
     * コンストラクタ.
     */
    private Manager(){
    }
    
    /**
     * オブジェクト情報を取得.
     * <BR><BR>
     * オブジェクト情報を取得します.
     * <BR>
     * @return Manager オブジェクト情報が返されます.
     */
    public static final Manager getInstance()
    {
        return SNGL ;
    }
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を実施します.
     */
    public synchronized void init()
    {
        if( m_table == null ){
            m_table = new CharTable() ;
        }
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を実施します.
     */
    public synchronized void destroy()
    {
        if( m_table != null ){
            m_table.clear() ;
        }
    }
    
    /**
     * 条件を設定.
     * <BR><BR>
     * 条件を設定します.
     * <BR>
     * @param name 設定対象要素名を設定します.
     * @param value 設定対象要素内容を設定します.
     * @exception InputException 入力例外.
     */
    public synchronized void put( String name,Object value )
        throws InputException
    {
        m_table.add( name,value ) ;
    }
    
    /**
     * 条件を削除.
     * <BR><BR>
     * 条件を削除します.
     * <BR>
     * @param name 削除対象の条件名を設定します.
     */
    public synchronized void remove( String name )
    {
        try{
            m_table.remove( name ) ;
        }catch( Exception e ){
        }
    }
    
    /**
     * 条件を取得.
     * <BR><BR>
     * 条件を取得します.
     * <BR>
     * @param name 取得対象の条件名を設定します.
     * @return Object 条件名に対する要素情報が返されます.
     */
    public synchronized Object get( String name )
    {
        return m_table.get( name ) ;
    }
    
    /**
     * 設定条件数を取得.
     * <BR><BR>
     * 設定されている条件数を取得します.
     * <BR>
     * @return int 設定されている条件数が返されます.
     */
    public synchronized int size()
    {
        return m_table.size() ;
    }
    
    /**
     * 設定条件名群を取得.
     * <BR><BR>
     * 設定されている条件名群を取得します.
     * <BR>
     * @return String[] 設定されている条件名群が返されます.
     */
    public synchronized String[] getNames()
    {
        return m_table.getNames() ;
    }
    
    /**
     * 対象名が存在するかチェック.
     * <BR><BR>
     * 対象名が存在するかチェックします.
     * <BR>
     * @param name チェック対象の条件名を設定します.
     * @return boolean チェック結果が返されます.
     */
    public synchronized boolean isData( String name )
    {
        return m_table.isData( name ) ;
    }
    
    
    
}

