/*
 * @(#)InitSerialize.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.serialize ;

import com.JRcServer.commons.beans.BaseBean;

/**
 * シリアライズ初期化インターフェイス.
 * <BR><BR>
 * このインターフェイスは[com.JRcServer.commons.serialize.SerializeCom.getSerialize()]で
 * オブジェクトをロードする場合に、このインターフェイスを継承していた場合に、
 * [initSerializable()]メソッドが呼び出されます.
 * <BR>
 * また、継承したオブジェクトでは、[initSerializable()]メソッドに対して、
 * 初期化が必要な条件を設定することで、永続化に対して円滑に利用することが
 * 出来ます.
 *
 * @version 1.00, 2005/10/02
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public interface InitSerialize extends BaseBean
{
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を行うメソッドです.<BR>
     * 基本的には、このインターフェイスを継承したオブジェクトは、
     * 初期化に必要な処理を実装することで、
     * [com.JRcServer.commons.serialize.SerializeCom.getSerialize()]からの、
     * オブジェクトロードの際に、このメソッドを呼び出してくれるので、
     * ロード後のオブジェクトを、円滑に利用する事が出来ます.
     */
    public void initSerializable() ;
    
}

