/*
 * @(#)NotUseSectorException.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.resource.cache;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.BaseException;


/**
 * セクタ検索結果、有効なセクタが存在しない場合の例外.
 *  
 * @version 2006/07/31
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NotUseSectorException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public NotUseSectorException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotUseSectorException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotUseSectorException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NotUseSectorException(String message)
    {
        super(message) ;
    }
}
