/*
 * @(#)CacheIO.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.resource.cache;


/**
 * キャッシュI/Oインターフェイス.
 *  
 * @version 2006/08/14
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface CacheIO {
    
    
    /**
     * １データ内要素数.
     */
    public static final int ELEMENT_LENGTH = CacheDef.SECTOR_LENGTH ;
    
    /**
     * １データ内要素内単位.
     */
    public static final int ELEMENT_MASK = ELEMENT_LENGTH - 1 ;
    
    /**
     * データビット数.
     */
    public static final int ELEMENT_BITCOUNT = CacheDef.SECTOR_BITCOUNT ;
    
    /**
     * キャッシュオブジェクトを取得.
     * <BR><BR>
     * キャッシュオブジェクトを取得します.
     * <BR>
     * @return Cache 対象のキャッシュオブジェクトが返されます.
     * @exception NotUseSectorException セクタ取得失敗例外.
     */
    public Cache newCacheObject()
        throws NotUseSectorException ;
    
    /**
     * キャッシュオブジェクトを取得.
     * <BR><BR>
     * キャッシュオブジェクトを取得します.
     * <BR>
     * @param newBytesLength 初期利用のバイト数を設定します.
     * @return Cache 対象のキャッシュオブジェクトが返されます.
     * @exception NotUseSectorException セクタ取得失敗例外.
     */
    public Cache newCacheObject( int newBytesLength )
        throws NotUseSectorException ;
    
    /**
     * 管理セクタ数を取得.
     * <BR><BR>
     * 管理セクタ数を取得します.
     * <BR>
     * @return int 管理セクタ数を取得します.
     */
    public int getMaxSector() ;
    
    /**
     * 現在利用中のセクタ数を取得.
     * <BR><BR>
     * 現在利用中のセクタ数を取得します.
     * <BR>
     * @return int 現在利用中のセクタ数が返されます.
     */
    public int getUseSector() ;
    
    /**
     * ユニークIDを取得.
     * <BR><BR>
     * このオブジェクトに対するユニークIDを取得します.
     * <BR>
     * @return long ユニークIDが返されます.
     */
    public long getUniqueID() ;
    
    /**
     * このオブジェクトが有効であるかチェック.
     * <BR><BR>
     * このオブジェクトが有効であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、オブジェクトは有効です.<BR>
     *                 [false]が返された場合、オブジェクトは無効です.
     */
    public boolean isUseObject() ;
    
}

