/*
 * @(#)UdpIODef.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net.uio;

import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.ResourceType;

/**
 * UDP-I/O定義データ.
 *
 * @version 1.00, 2005/03/24
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
class UdpIODef
{
    
    /**
     * パケットヘッダ長.
     * 18Byte.
     */
    public static final int PACKET_HEADER_LENGTH = 
        2 +     // パケットヘッダ.
        4 +     // メインID.
        4 +     // サブID.
        4       // ランダムID.
    ;
    
    /**
     * パケットヘッダ.
     */
    public static final byte[] PACKET_HEADER = {
        0x00000055,0x0000004f
    } ;
    
    
    /**
     * 送信ポートデフォルト値.
     */
    public static final int DEFAULT_SEND_PORT = 22055 ;
    
    /**
     * 受信ポートデフォルト値.
     */
    public static final int DEFAULT_RECAIVE_PORT = 22155 ;
    
    /**
     * 送受信パケットデフォルト値.
     */
    public static final int DEFAULT_PACKET = 1024 ;
    
    /**
     * 送受信パケット最小値.
     */
    public static final int MIN_PACKET = 512 ;
    
    /**
     * 送受信パケット最大値.
     */
    public static final int MAX_PACKET = 8192 ;
    
    /**
     * ファーストデータタイムアウト値.
     */
    public static final int FIRST_RECV_TIMEOUT = 250 ;
    
    /**
     * ファーストデータリトライタイミング.
     */
    public static final int FIRST_ERROR_RETRY = 3 ;
    
    /**
     * パケットデータタイムアウト値.
     */
    public static final int PACKET_RECV_TIMEOUT = 150 ;
    
    /**
     * パケットデータリトライタイミング.
     */
    public static final int PACKET_ERROR_RETRY = 128 ;
    
    /**
     * パケットデータ再送データ取得リトライ値.
     */
    public static final int PACKET_LOST_RETRY = 5 ;
    
    /**
     * 受信パケットテーブル削除時間.
     */
    public static final int RCV_PACKET_CLEAR_TIME = 1500 ;
    
    
    
    /**
     * パケット情報 : パケットヘッダサブID.
     */
    public static final int PACKET_HEADER_SUBID = -1 ;
    
    /**
     * パケット情報 : 確認電文.
     */
    public static final int PACKET_CCONN_MAX_PACKET = 0 ;
    
    
    
    /**
     * パケットステータスチェック.
     */
    public static final int STATE_CHECK = 0xffe80100 ;
    
    /**
     * 電文開始ステータスチェック.
     */
    public static final int FIRST_CHECK = 0xfff80100 ;
    
    /**
     * 正常テータスチェック.
     */
    public static final int SUCCESS_CHECK = 0xffec0100 ;
    
    /**
     * 警告ステータスチェック.
     */
    public static final int WARNING_CHECK = 0xffed0100 ;
    
    /**
     * 電文エラーステータスチェック.
     */
    public static final int ERROR_CHECK = 0xffee0100 ;
    
    /**
     * パケット情報 : ステータスコード : 存在なし.
     */
    public static final int NOT_STATE_CODE = 0xffe80000 ;
    
    /**
     * パケット情報 : ステータスコード : 電文エラーコード.
     */
    public static final int ERROR_STATE_CODE = 0xffee01ff ;
    
    /**
     * パケット情報 : ステータスコード : 電文開始コード.
     */
    public static final int FIRST_STATE_CODE = 0xfffc0100 ;
    
    /**
     * パケット情報 : ステータスコード : 電文開始エラーコード.
     */
    public static final int FIRST_ERROR_STATE_CODE = 0xfffe0101 ;
    
    /**
     * パケット情報 : ステータスコード : 電文開始正常コード.
     */
    public static final int FIRST_SUCCESS_STATE_CODE = 0xfffc0102 ;
    
    /**
     * パケット情報 : ステータスコード : 送信終了コード.
     */
    public static final int END_STATE_CODE = 0xffec0103 ;
    
    /**
     * パケット情報 : ステータスコード : ロストパケット要求コード.
     */
    public static final int RESEND_STATE_CODE = 0xffed0104 ;
    
    /**
     * パケット情報 : ステータスコード : 受信ロール許容オーバー.
     */
    public static final int ROLL_FULL_STATE_CODE = 0xffee0105 ;
    
    /**
     * パケット情報 : ステータスコード : 通知確認OK.
     */
    public static final int FIRST_NOTICE_OK_STATE_CODE = 0xfffc0106 ;
    
    
    /**
     * 通信バッファデフォルト値.
     * 256KByte.
     */
    public static final int DEFAULT_UDP_BUFFER = 262144 ;
    
    /**
     * 通信スレッドデフォルト値.
     */
    public static final int DEFAULT_THREAD_SIZE = 2 ;
    
    /**
     * 通信コアスレッドデフォルト値.
     */
    public static final int DEFAULT_CORE_THREAD_SIZE = 1 ;
    
    /**
     * 通信スレッド最小値.
     */
    public static final int MIN_THREAD_SIZE = 1 ;
    
    /**
     * 通信スレッド最大値.
     */
    public static final int MAX_THREAD_SIZE = 8 ;
    
    /**
     * ロール設定最大数.
     */
    public static final int MAX_ROLL_SIZE = 9999 ;
    
    /**
     * 送信設定待ちカウント.
     */
    public static final int WAIT_SET_SEND_ROLL_COUNT = 99 ;
    
    /**
     * 再送カウントデフォルト値.
     */
    public static final int DEF_RESEND_COUNT = 8 ;
    
    /**
     * 再送カウント : 最小値.
     */
    public static final int MIN_RESEND_COUNT = 3 ;
    
    /**
     * 基本リソースタイプ.
     */
    public static final ResourceType DEF_RESOURCE_TYPE = new ResourceType(
        BinResource.BIN_RESOURCE_TYPE_MEMORY,null,-1L
    ) ;
    
}

