/*
 * @(#)UIOResultCallback.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net.uio;

/**
 * UDP送信/受信完了コールバックインターフェイス.
 * <BR><BR>
 * 指定されたUDP送信/受信処理が完了した場合に呼び出される
 * コールバックインターフェイスです.
 *
 * @version 1.00, 2005/07/28
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public interface UIOResultCallback
{
    
    /**
     * 送信/受信完了コールバック.
     * <BR><BR>
     * 送信/受信が完了した場合に呼び出されるコールバックメソッドです.
     * <BR>
     * @param id 送信/受信されたIDが設定されます.
     */
    public void callback( int id ) ;
    
}

