/*
 * @(#)MgcWriteManager.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net.mgc ;

/**
 * マルチキャストグループ書き込み用管理オブジェクト.
 * <BR><BR>
 * マルチキャストグループ書き込み用を管理するオブジェクトです.
 *  
 * @version 1.0.0 2005/07/29
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface MgcWriteManager
{
    
    /**
     * 管理情報を更新.
     * <BR><BR>
     * 対象の情報を更新します.<BR>
     * また、対象条件がテーブルに存在しない場合は追加となります.
     * <BR>
     * @param val 更新対象の情報を設定します.
     * @return boolean 新たに追加された場合の条件を返します.<BR>
     *                [true]が返された場合、新たに追加されました.<BR>
     *                [false]が返された場合、条件を更新したか処理に失敗しました.
     */
    public boolean renew( MgcValue val ) ;
    
    /**
     * 管理情報から削除.
     * <BR><BR>
     * 管理情報から削除します.
     * <BR>
     * @param val 削除対象の要素を設定します.
     * @return boolean 削除処理が成功条件が返されます.<BR>
     *                 [true]が返された場合成功しました.<BR>
     *                 [false]が返された場合存在しないか、失敗しました.
     */
    public boolean remove( MgcValue val ) ;
    
    /**
     * 対象のサーバ名の情報をソート.
     * <BR><BR>
     * 対象のサーバ名の情報を接続数をキーとしてソートします.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     */
    public void sort( String name ) ;
    
}

