/*
 * @(#)MgcValue.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net.mgc ;

import java.io.Serializable;
import java.net.InetAddress;

import com.JRcServer.commons.net.ConnectAddress;

/**
 * マルチキャストグループ要素オブジェクト.
 * <BR><BR>
 * 接続情報を格納するマルチキャストグループ要素オブジェクトです.
 *  
 * @version 1.0.0 2005/07/29
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface MgcValue extends Comparable,Serializable
{
    
    /**
     * 対象プロトコルタイプ : TCP.
     */
    public static final int PROTOCOL_TYPE_TCP = 0x00000001 ;
    
    /**
     * 対象プロトコルタイプ : UDP.
     */
    public static final int PROTOCOL_TYPE_UDP = 0x00000002 ;
    
    /**
     * 対象プロトコルタイプ : Malticast.
     */
    public static final int PROTOCOL_TYPE_MCAST = 0x00000003 ;
    
    
    
    /**
     * 設定されているサーバ名を取得.
     * <BR><BR>
     * 設定されているサーバ名を取得します.
     * <BR>
     * @return String 設定されているサーバ名が返されます.<BR>
     *                [null]が返された場合、このオブジェクトは無効です.
     */
    public String getServerName() ;
    
    /**
     * 設定されているサーバIDを取得.
     * <BR><BR>
     * 設定されているサーバIDを取得します.
     * <BR>
     * @return int 設定されているサーバIDが返されます.<BR>
     *             [-1]が返された場合、このオブジェクトは無効です.
     */
    public int getServerID() ;
    
    /**
     * 設定されているプロトコルタイプを取得.
     * <BR><BR>
     * 設定されているプロトコルタイプを取得します.
     * <BR>
     * @return int 設定されているプロトコルタイプが返されます.<BR>
     *             [MgcValue.PROTOCOL_TYPE_TCP]が返された場合、TCP/IPを示します.<BR>
     *             [MgcValue.PROTOCOL_TYPE_UDP]が返された場合、UDPを示します.<BR>
     *             [MgcValue.PROTOCOL_TYPE_MCAST]が返された場合、Multicastを示します.<BR>
     *             [-1]が返された場合、このオブジェクトは無効です.
     */
    public int getProtocolType() ;
    
    /**
     * 設定されているバインドアドレスを取得.
     * <BR><BR>
     * 設定されているバインドアドレスを取得します.
     * <BR>
     * @return InetAddress 設定されているバインドアドレスが返されます.<BR>
     *                     [null]が返された場合、このオブジェクトは無効です.
     */
    public InetAddress getBindAddress() ;
    
    /**
     * 設定されているバインドポートを取得.
     * <BR><BR>
     * 設定されているバインドポート番号を取得します.
     * <BR>
     * @return int 設定されているバインドポート番号が返されます.<BR>
     *             [-1]が返された場合、このオブジェクトは無効です.
     */
    public int getBindPort() ;
    
    /**
     * 設定されているバインド情報を取得.
     * <BR><BR>
     * 設定されているバインド情報を取得します.
     * <BR>
     * @param out 取得先のオブジェクトを設定します.
     * @return boolean 取得結果が返されます.<BR>
     *                 [true]が返された場合、正常に取得できました.<BR>
     *                 [false]が返された場合、取得出来ませんでした.
     */
    public boolean getBind( ConnectAddress out ) ;
    
    /**
     * 更新時間を取得.
     * <BR><BR>
     * 更新時間を取得します.
     * <BR>
     * @return long 更新時間返されます.<BR>
     *              [-1L]が返された場合、このオブジェクトは無効です.<BR>
     *              [Long.MIN_VALUE]が返された場合、この条件は設定されていません.
     */
    public long getUpdateTime() ;
    
    /**
     * 現在のコネクションカウントを取得.
     * <BR><BR>
     * 現在のコネクションカウントを取得します.
     * <BR>
     * @return int 現在のコネクションカウントが返されます.<BR>
     *             [-1]が返された場合、このオブジェクトは無効です.
     */
    public int getConnectCount() ;
    
    /**
     * 現在のMgc標準時間を取得.
     * <BR><BR>
     * 現在のMgc標準時間を取得します.
     * <BR>
     * @return long 現在のMgc標準時間が返されます.<BR>
     *              [-1L]が返された場合、このオブジェクトは無効です.
     */
    public long getDefaultTime() ;
    
    /**
     * 前回応答時間を取得.
     * <BR><BR>
     * 前回の応答時間を取得します.
     * <BR>
     * @return int 前回の応答時間が返されます.<BR>
     *             [-1]が返された場合、このオブジェクトは無効です.<BR>
     *             [Integer.MIN_VALUE]が返された場合、この条件は設定されていません.
     */
    public int getBeforeResponse() ;
    
    /**
     * このオブジェクトが有効であるかチェック.
     * <BR><BR>
     * このオブジェクトが有効であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、オブジェクトは有効です.<BR>
     *                 [false]が返された場合、オブジェクトは無効です.
     */
    public boolean isUse() ;
    
}
