/*
 * @(#)MgcManager.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net.mgc ;

import java.net.InetAddress;

import com.JRcServer.commons.net.ConnectAddress;

/**
 * マルチキャストグループ管理.
 * <BR><BR>
 * マルチキャストグループを管理します.
 *  
 * @version 1.0.0 2005/07/29
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface MgcManager
{
    
    /**
     * 対象サーバ名に対するサーバIDを取得.
     * <BR><BR>
     * 対象サーバ名に対するサーバIDを取得します.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     * @return int サーバIDが返されます.<BR>
     *             [-1]が返された場合、取得に失敗しました.
     */
    public int getServerID( String name ) ;
    
    /**
     * 対象サーバ名に対するプロトコルタイプを取得.
     * <BR><BR>
     * 対象サーバ名に対するプロトコルタイプを取得します.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     * @return int プロトコルタイプが返されます.<BR>
     *             [-1]が返された場合、取得に失敗しました.
     */
    public int getProtocolType( String name ) ;
    
    /**
     * 対象サーバ名に対するコネクションアドレスを取得.
     * <BR><BR>
     * 対象サーバ名に対するコネクションアドレスを取得します.
     * <BR>
     * @param out 格納対象のコネクションオブジェクトを設定します.
     * @param name 対象のサーバ名を設定します.
     * @return boolean 取得結果が返されます.<BR>
     *                 [true]が返された場合、情報の取得に成功しました.<BR>
     *                 [false]が返された場合、情報の取得に失敗しました.
     */
    public boolean getConnectAddress( ConnectAddress out,String name ) ;
    
    /**
     * 対象サーバ名に対するコネクション数を取得.
     * <BR><BR>
     * 対象サーバ名に対するコネクション数を取得します.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     * @return int コネクション数が返されます.<BR>
     *             [-1]が返された場合、取得に失敗しました.
     */
    public int getConnectCount( String name ) ;
    
    /**
     * 対象サーバ名に対する前回応答時間を取得.
     * <BR><BR>
     * 対象サーバ名に対する前回応答時間を取得します.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     * @return int 前回の応答時間が返されます.<BR>
     *             [-1]が返された場合、このオブジェクトは無効です.<BR>
     *             [Integer.MIN_VALUE]が返された場合、この条件は設定されていません.
     */
    public int getBeforeResponse( String name ) ;
    
    /**
     * 対象サーバ名の条件を取得.
     * <BR><BR>
     * 対象サーバ名の条件を取得します.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     * @return MgcValue[] 対象の要素群が返されます.<BR>
     *                    [null]が返された場合、対象のサーバ名の
     *                    要素は存在しません.
     */
    public MgcValue[] get( String name ) ;
    
    /**
     * 対象サーバ名に対する要素数を取得.
     * <BR><BR>
     * 対象サーバ名に対する要素数を取得します.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     * @return int 要素数が返されます.
     */
    public int getSize( String name ) ;
    
    /**
     * 全ての条件を取得.
     * <BR><BR>
     * 全ての条件を取得します.
     * <BR>
     * @return MgcValue[] 対象の要素群が返されます.<BR>
     *                    [null]が返された場合要素は存在しません.
     */
    public MgcValue[] getAll() ;
    
    /**
     * 全ての要素数を取得.
     * <BR><BR>
     * 現在格納されている全ての要素数を取得します.
     * <BR>
     * @return int 全ての要素数が返されます.
     */
    public int getAllSize() ;
    
    /**
     * 対象のサーバ名一覧を取得.
     * <BR><BR>
     * 対象のサーバ名一覧を取得します.
     * <BR>
     * @return String[] 現在認識されているサーバ名一覧が返されます.<BR>
     *                  [null]が返された場合情報は存在しません.
     */
    public String[] getServerNames() ;
    
    /**
     * 対象のサーバ名数を取得.
     * <BR><BR>
     * 対象のサーバ名数を取得します.
     * <BR>
     * @return int 現在認識されているサーバ名数が返されます.
     */
    public int getServerSize() ;
    
    /**
     * シリアライズ先のファイル名を取得.
     * <BR><BR>
     * 設定されているシリアライズ先のファイル名を取得します.
     * <BR>
     * @return String シリアライズ先のファイル名が返されます.<BR>
     *                [null]が返された場合、情報は存在しません.
     */
    public String getSerializeName() ;
    
    /**
     * 対象条件が有効であるかチェック.
     * <BR><BR>
     * 対象の条件が有効であるかチェックします.
     * <BR>
     * @param name 対象のサーバ名を設定します.
     * @param addr 対象のアドレス情報を設定します.
     * @param port 対象のポート番号を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、有効です.<BR>
     *                 [false]が返された場合、無効です.
     */
    public boolean isUseMgc( String name,InetAddress addr,int port ) ;
    
}

