/*
 * @(#)UnknownConnectException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.BaseException;

/**
 * コネクション先不明例外.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class UnknownConnectException extends CommunicateException
{
    /**
     * コンタストラクタ.
     */
    public UnknownConnectException()
    {
        super( CommunicateException.UNKNOWN_CONNECTION ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public UnknownConnectException(Throwable e)
    {
        super( e,CommunicateException.UNKNOWN_CONNECTION ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public UnknownConnectException(BaseException e)
    {
        super( e,CommunicateException.UNKNOWN_CONNECTION ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public UnknownConnectException(String message)
    {
        super( CommunicateException.UNKNOWN_CONNECTION,message ) ;
        
    }
}
