/*
 * @(#)TelegramArray.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net;

import java.net.InetAddress;

import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.util.array.ObjectArray;

/**
 * 電文管理オブジェクト.
 * <BR><BR>
 * 電文を管理するためのオブジェクトです.
 *  
 * @version 1.0.0 2005/08/08
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class TelegramArray
{
    
    /**
     * データ管理用.
     */
    private final ObjectArray m_table = new ObjectArray() ;
    
    /**
     * コンストラクタ.
     */
    public TelegramArray(){}
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 対象の情報をクリアします.
     */
    public final void clear()
    {
        int i ;
        int len ;
        TelegramArrayChild ch = null ;
        ObjectArray ary = null ;
        
        synchronized( this ){
            
            ary = m_table ;
            len = ary.size() ;
            
            for( i = 0 ; i < len ; i ++ ){
                ch = ( TelegramArrayChild )ary.get( i ) ;
                if( ch != null ){
                    if( ch.RES != null ){
                        ch.RES.clear() ;
                    }
                }
                ch.ADDR = null ;
                ch.RES = null ;
                ch = null ;
            }
            
            ary.clear() ;
        }
        
        ch = null ;
        ary = null ;
    }
    
    /**
     * 情報設定.
     * <BR><BR>
     * 情報を設定します.
     * <BR>
     * @param bin 対象のバイナリ情報を設定します.
     */
    public final void set( InetAddress addr,int port,BinResource bin )
    {
        TelegramArrayChild ch = null ;
        
        ch = new TelegramArrayChild() ;
        ch.ADDR = addr ;
        ch.PORT = port ;
        ch.RES = bin ;
        
        try{
            synchronized( this ){
                m_table.add( ch ) ;
            }
        }catch( Exception e ){
        }
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 情報が設定されている場合、取得されます.
     * <BR>
     * @param out 格納対象のコネクションアドレスを設定します.<BR>
     *            [null]を設定した場合、格納されません.
     * @return BinResource 対象のバイナリが返されます.<BR>
     *                     [null]が返された場合、情報は存在しません.
     */
    public final BinResource get( ConnectAddress out )
    {
        TelegramArrayChild ch = null ;
        BinResource ret = null ;
        
        synchronized( this ){
            if( m_table.size() > 0 ){
                ch = ( TelegramArrayChild )m_table.remove( 0 ) ;
            }
        }
        
        if( ch != null ){
            try{
                if( out != null ){
                    out.create( ch.ADDR,ch.PORT ) ;
                }
                ret = ch.RES ;
            }catch( Exception e ){
                ret = null ;
            }finally{
                ch = null ;
            }
        }
        
        return ret ;
    }
    
    /**
     * 格納情報数を取得.
     * <BR><BR>
     * 現在格納されている情報数が返されます.
     * <BR>
     * @return int 格納されている情報数が返されます.
     */
    public final int size()
    {
        int ret ;
        
        synchronized( this ){
            ret = m_table.size() ;
        }
        
        return ret ;
    }
    
}

/**
 * チャイルド要素.
 */
class TelegramArrayChild{
    InetAddress ADDR = null ;
    int PORT = -1 ;
    BinResource RES = null ;
}

