/*
 * @(#)NotInterfaceException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.BaseException;
import com.JRcServer.commons.exception.NotExistException;

/**
 * 指定インターフェイス非存在例外処理.
 *  
 * @version 1.0.0 2005/02/06
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NotInterfaceException extends NotExistException
{
    /**
     * コンタストラクタ.
     */
    public NotInterfaceException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotInterfaceException(Throwable e)
    {
        super(e.getLocalizedMessage()) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotInterfaceException(BaseException e)
    {
        super(e.getLocalizedMessage()) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NotInterfaceException(String message)
    {
        super(message) ;
    }
}
