/*
 * @(#)NetAdapterImpl.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net;

import java.util.Locale;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.UnsupportException;
import com.JRcServer.commons.sys.Os;

/**
 * ネットワークアダプタ情報取得.
 * <BR><BR>
 * ネットワークアダプタ情報を取得します.<BR>
 * 現在対応しているOSタイプは以下の通りです.<BR>
 * ・WindowsNT系<BR>
 * ・Linux系<BR>
 * ・BSD系のUNIX<BR>
 * それ以外のOSには対応していません.
 *  
 * @version 1.0.0 2004/10/15
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
class NetAdapterImpl
{
    
    /**
     * Linux.
     */
    private static final String LINUX = "linux" ;
    
    /**
     * コンストラクタ.
     */
    private NetAdapterImpl()
    {
    }
    
    /**
     * ネットワーク情報取得.
     * <BR><BR>
     * ネットワーク情報を取得します.
     * <BR>
     * @return NetAdapter 実行結果情報が返されます.
     * @exception UnsupportException サポート外例外.
     */
    public static final NetAdapter getAdapter()
        throws UnsupportException
    {
        
        String os_name = null ;
        NetAdapterBase ret = null ;
        
        os_name = System.getProperty( "os.name" ).toLowerCase( Locale.US ) ;
        
        try{
            
            switch( Os.getInstance().getOS() ){
                
                // OSがWindowsNT系の場合.
                case Os.OS_WINNT :
                
                    ret = new NetAdapterByWinNT() ;
                    ret.flush() ;
                    
                    break ;
                    
                // OSがUNIX系の場合.
                case Os.OS_UNIX :
                    
                    // OSがLinuxの場合.
                    if( os_name.indexOf( NetAdapterImpl.LINUX ) != -1 ){
                        ret = new NetAdapterByLinux() ;
                        ret.flush() ;
                    }
                    // OSがその他のBSD系UNIXの場合.
                    else{
                        ret = new NetAdapterByBsd() ;
                        ret.flush() ;
                    }
                    
                    break ;
                    
                // その他のOSの場合.
                default :
                    
                    throw new UnsupportException(
                        "対象のOSタイプ(" + os_name + ")はサポート外です"
                    ) ;
                    
            }
            
        }catch( UnsupportException us ){
            throw us ;
        }catch( AccessException ac ){
            throw new UnsupportException(
                "対象のOSタイプ(" + os_name + ")はサポート外です"
            ) ;
        }finally{
            os_name = null ;
        }
        
        return ret ;
        
    }
    
}

