/*
 * @(#)NetAdapterByLinux.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.util.UtilCom;

/**
 * ネットワークアドレス取得Linux版.
 * <BR><BR>
 * Linux版のネットワークアドレス取得処理です.
 *  
 * @version 1.0.0 2004/10/13
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
class NetAdapterByLinux extends NetAdapterBase
{
    
    /**
     * IPアドレス取得コマンド.
     */
    public static final String IPCONFIG_COMMAND = "ifconfig";
    
    /**
     * 媒体開始文字.
     */
    private static final String ADAPTER_NAME_1 = "link" ;
    private static final String ADAPTER_NAME_2 = "encap:" ;
    
    /**
     * IPアドレス区切り値.
     */
    private static final char DIV_IP_CODE = '.' ;
    
    /**
     * macアドレス区切り値.
     */
    private static final char DIV_MAC_CODE = ':' ;
    
    /**
     * IPアドレス.
     */
    private static final String IP_ADDR_1 = "inet" ;
    private static final String IP_ADDR_2 = "addr:" ;
    
    /**
     * サブネットマスク.
     */
    private static final String SUB_NET = "mask" ;
    
    /**
     * macアドレス.
     */
    private static final String MAC_ADDR = "hwaddr" ;
    
    
    /**
     * コンストラクタ.
     */
    public NetAdapterByLinux()
    {
    }
    
    /**
     * ネットワーク情報取得処理.
     * <BR><BR>
     * 対象のネットワーク情報を取得します.
     * <BR>
     * @exception AccessException アクセス例外.
     */
    public final void flush() throws AccessException
    {
        int i,j ;
        int len ;
        int lenJ ;
        int pnt ;
        int off ;
        int st,et ;
        int localCheck ;
        
        char code ;
        
        String[] cmdOut = null ;
        String cmd = null ;
        StringBuffer buf = null ;
        String name = null ;
        String value = null ;
        
        try{
            
            this.clear() ;
            cmdOut = super.runExec( NetAdapterByLinux.IPCONFIG_COMMAND ) ;
            
            len = cmdOut.length ;
            for( i = 0,localCheck = 0 ; i < len ; i ++ ){
                
                cmd = cmdOut[ i ].toLowerCase() ;
                cmdOut[ i ] = null ;
                
                // adapter名を取得.
                if(
                    ( off = cmd.indexOf( NetAdapterByLinux.ADAPTER_NAME_1 ) ) != -1 &&
                    cmd.indexOf( NetAdapterByLinux.ADAPTER_NAME_2,off ) != -1
                )
                {
                    
                    pnt = off ;
                    
                    name = UtilCom.trimPlus( cmd.substring( 0,pnt ) ) ;
                    
                }
                
                // IPアドレスの場合.
                if(
                    ( off = cmd.indexOf( NetAdapterByLinux.IP_ADDR_1 ) ) != -1 &&
                    ( pnt = cmd.indexOf( NetAdapterByLinux.IP_ADDR_2,off ) ) != -1
                )
                {
                    pnt = pnt + NetAdapterByLinux.IP_ADDR_2.length() ;
                    lenJ = cmd.length() ;
                    
                    for( j = pnt,st = -1,et = -1 ; j < lenJ ; j ++ ){
                        
                        code = cmd.charAt( j ) ;
                        
                        if( st == -1 ){
                            if( code >= '0' && code <= '9' ){
                                st = j ;
                            }
                        }
                        else if(
                            code == NetAdapterByLinux.DIV_IP_CODE ||
                            ( code >= '0' && code <= '9' )
                        )
                        {
                            et = j ;
                        }
                        else{
                            break ;
                        }
                        
                    }
                    
                    value = UtilCom.trimPlus( cmd.substring( st,et+1 ) ) ;
                    
                    // 対象IPアドレスがローカルアドレスを示す場合.
                    if( value.equals( NetDef.LOCAL_HOST ) == true ){
                        localCheck ++ ;
                    }
                    
                    super.addCategory( name,NetAdapter.CATEGORY_IPADDR,value ) ;
                }
                
                // サブネットマスクの場合.
                if( ( pnt = cmd.indexOf( NetAdapterByLinux.SUB_NET ) ) != -1 ){
                    pnt = pnt + NetAdapterByLinux.SUB_NET.length() ;
                    lenJ = cmd.length() ;
                    
                    for( j = pnt,st = -1,et = -1 ; j < lenJ ; j ++ ){
                        
                        code = cmd.charAt( j ) ;
                        
                        if( st == -1 ){
                            if( code >= '0' && code <= '9' ){
                                st = j ;
                            }
                        }
                        else if(
                            code == NetAdapterByLinux.DIV_IP_CODE ||
                            ( code >= '0' && code <= '9' )
                        )
                        {
                            et = j ;
                        }
                        else{
                            break ;
                        }
                        
                    }
                    
                    value = UtilCom.trimPlus( cmd.substring( st,et+1 ) ) ;
                    super.addCategory( name,NetAdapter.CATEGORY_SUBNET,value ) ;
                }
                
                // MACアドレスの場合.
                if( ( pnt = cmd.indexOf( NetAdapterByLinux.MAC_ADDR ) ) != -1 ){
                    pnt = pnt + NetAdapterByLinux.MAC_ADDR.length() ;
                    lenJ = cmd.length() ;
                    
                    for( j = pnt,st = -1,et = -1 ; j < lenJ ; j ++ ){
                        
                        code = cmd.charAt( j ) ;
                        
                        if( st == -1 ){
                            if(
                                ( code >= '0' && code <= '9' ) ||
                                ( code >= 'a' && code <= 'f' )
                            )
                            {
                                st = j ;
                            }
                        }
                        else if(
                            code == NetAdapterByLinux.DIV_MAC_CODE ||
                            ( code >= '0' && code <= '9' ) ||
                            ( code >= 'a' && code <= 'f' )
                        )
                        {
                            et = j ;
                        }
                        else{
                            break ;
                        }
                        
                    }
                    
                    value = UtilCom.trimPlus( cmd.substring( st,et+1 ) ).toUpperCase() ;
                    super.addCategory( name,NetAdapter.CATEGORY_MACADDR,value ) ;
                }
                
            }
            
            // ローカルアドレスが存在しない場合.
            if( localCheck == 0 ){
                // アドレスを追加.
                super.addCategory(
                    NetAdapterBase.DEFAULT_ETHER_NAME,
                    NetAdapter.CATEGORY_IPADDR,
                    NetDef.LOCAL_HOST
                ) ;
                // ホスト名を追加.
                super.addCategory(
                    NetAdapterBase.DEFAULT_ETHER_NAME,
                    NetAdapter.CATEGORY_SUBNET,
                    NetAdapterBase.LO_HOST_SUB
                ) ;
            }
            
        }catch( AccessException ac ){
            this.clear() ;
            throw ac ;
        }catch( Exception t ){
            this.clear() ;
        }finally{
            cmdOut = null ;
            cmd = null ;
            buf = null ;
            name = null ;
            value = null ;
        }
        
    }
    
}

