/*
 * @(#)ClosedConnectException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.BaseException;

/**
 * 接続先クローズ例外.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class ClosedConnectException extends CommunicateException
{
    /**
     * コンタストラクタ.
     */
    public ClosedConnectException()
    {
        super( CommunicateException.CLOSE_CONNECT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public ClosedConnectException(Throwable e)
    {
        super( e,CommunicateException.CLOSE_CONNECT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public ClosedConnectException(BaseException e)
    {
        super( e,CommunicateException.CLOSE_CONNECT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public ClosedConnectException(String message)
    {
        super( CommunicateException.CLOSE_CONNECT,message ) ;
        
    }
}
