/*
 * @(#)BaseTcpServer.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.net;

import java.net.InetAddress;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.util.array.ObjectArray;


/**
 * TCP/IPサーバインターフェイス.
 * <BR><BR>
 * 対象のTCP/IPデータ処理を管理するインターフェイスです.
 *
 * @version 1.00, 2004/10/05
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public interface BaseTcpServer
{
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port )
        throws InputException,AccessException ;
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @param timeout 要素タイムアウト値を設定します.<BR>
     *                設定可能な最小値は[30000L]です.<BR>
     *                設定可能な最大値は[3600000L]です.<BR>
     *                また、タイムアウト指定なしの場合[0L]を指定します.<BR>
     *                また、単位はミリ秒です.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port,long timeout )
        throws InputException,AccessException ;
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @param backlog 接続最大数を設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port,int backlog )
        throws InputException,AccessException ;
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @param backlog 接続最大数を設定します.
     * @param timeout 要素タイムアウト値を設定します.<BR>
     *                設定可能な最小値は[30000L]です.<BR>
     *                設定可能な最大値は[3600000L]です.<BR>
     *                また、タイムアウト指定なしの場合[0L]を指定します.<BR>
     *                また、単位はミリ秒です.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port,int backlog,long timeout )
        throws InputException,AccessException ;
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @param addr バインド先のアドレスを設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port,InetAddress addr )
        throws InputException,AccessException ;
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @param timeout 要素タイムアウト値を設定します.<BR>
     *                設定可能な最小値は[30000L]です.<BR>
     *                設定可能な最大値は[3600000L]です.<BR>
     *                また、タイムアウト指定なしの場合[0L]を指定します.<BR>
     *                また、単位はミリ秒です.
     * @param addr バインド先のアドレスを設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port,long timeout,InetAddress addr )
        throws InputException,AccessException ;
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @param backlog 接続最大数を設定します.
     * @param addr バインド先のアドレスを設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port,int backlog,InetAddress addr )
        throws InputException,AccessException ;
    
    /**
     * サーバオープン.
     * <BR><BR>
     * サーバオープンを行います.
     * <BR>
     * @param port オープンポート番号を設定します.
     * @param backlog 接続最大数を設定します.
     * @param timeout 要素タイムアウト値を設定します.<BR>
     *                設定可能な最小値は[30000L]です.<BR>
     *                設定可能な最大値は[3600000L]です.<BR>
     *                また、タイムアウト指定なしの場合[0L]を指定します.<BR>
     *                また、単位はミリ秒です.
     * @param addr バインド先のアドレスを設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( int port,int backlog,long timeout,InetAddress addr )
        throws InputException,AccessException ;
    
    /**
     * クローズ処理.
     * <BR><BR>
     * クローズ処理を実施します.
     */
    public void close() ;
    
    /**
     * 要素タイムアウト値を設定.
     * <BR><BR>
     * サーバコネクションによる各要素のタイムアウト値を設定します.
     * <BR>
     * @param timeout 要素タイムアウト値を設定します.<BR>
     *                設定可能な最小値は[30000L]です.<BR>
     *                設定可能な最大値は[3600000L]です.<BR>
     *                また、タイムアウト指定なしの場合[0L]を指定します.<BR>
     *                また、単位はミリ秒です.
     * @exception InputException 入力例外.
     */
    public void setTimeout( long timeout )
        throws InputException ;
    
    /**
     * 送受信バッファ長を設定.
     * <BR><BR>
     * 送受信バッファ長を設定します.
     * <BR>
     * @param bufLen 送受信送受信バッファ長を設定します.
     * @exception InputException 入力例外.
     */
    public void setBuffer( int bufLen )
        throws InputException ;
    
    /**
     * コネクション群を取得.
     * <BR><BR>
     * コネクション群を取得します.
     * <BR>
     * @param val コネクション群が返されます.
     * @return int 取得されたコネクション数が返されます.
     */
    public int getAccept( ObjectArray val ) ;
    
    /**
     * 要素タイムアウト値を取得.
     * <BR><BR>
     * サーバコネクションによる各要素のタイムアウト値が返されます.
     * <BR>
     * @return long タイムアウト値が返されます.
     */
    public long getTimeout() ;
    
    /**
     * サーバ同時接続数を取得.
     * <BR><BR>
     * サーバ同時接続数を取得します.
     * <BR>
     * @return int サーバ同時接続数が返されます.
     */
    public int getMaxConnect() ;
    
    /**
     * 送受信バッファ長値を取得.
     * <BR><BR>
     * 設定されている送受信バッファ長値が返されます.
     * <BR>
     * @return int 対象の送受信バッファ長が返されます.
     */
    public int getBuffer() ;
    
    /**
     * バインドアドレスを取得.
     * <BR><BR>
     * 対象のバインドアドレスを取得します.
     * <BR>
     * @param addr 対象のバインドアドレスが返されます.
     */
    public void getBindAddress( ConnectAddress addr ) ;
    
    /**
     * サーバコネクション要素が存在するかチェック.
     * <BR><BR>
     * サーバコネクション要素が存在するかチェックします.
     * <BR>
     * @return boolean 存在結果が返されます.<BR>
     *                 [true]が返された場合、新しい要素は存在します.<BR>
     *                 [false]が返された場合、新しい要素は存在しません.
     */
    public boolean isAccept() ;
    
    /**
     * 接続チェック.
     * <BR><BR>
     * 接続されているかチェックします.
     * <BR>
     * @return boolean 接続状況が返されます.<BR>
     *                 [true]が返された場合、接続されています.
     *                 [false]が返された場合、接続されていません.
     */
    public boolean isConnect() ;
    
}

