/*
 * @(#)EnvFile.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.io.env;

import java.io.File;

import com.JRcServer.commons.io.IODef;
import com.JRcServer.commons.serialize.SerializeUtil;

/**
 * 環境変数対応版[java.io.File]オブジェクト.
 * <BR><BR>
 * [java.io.File]の利用にあたり、環境変数が含まれている場合、
 * それらを解析します.
 *  
 * @version 1.0.0 2005/05/02
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class EnvFile extends File
{
	
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            EnvFile.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    public EnvFile( File file,String child )
        throws NullPointerException 
    {
        super( file,IODef.convertEnvName( child ) ) ;
    }
    
    public EnvFile( String pathname )
        throws NullPointerException 
    {
        super( IODef.convertEnvName( pathname ) ) ;
    }
    
    public EnvFile( String parent,String child )
        throws NullPointerException 
    {
        super( IODef.convertEnvName( parent ),IODef.convertEnvName( child ) ) ;
    }
}

