/*
 * @(#)SwitchMount.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.exception.AccessException;

/**
 * マウント/アンマウント処理.
 * <BR><BR>
 * マウント/アンマウント処理用インターフェイスを提供します.
 *
 * @version 1.00, 2004/11/04
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public interface SwitchMount
{
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() ;
    
    /**
     * マウント処理.
     * <BR><BR>
     * 対象オブジェクトをマウントします.
     * <BR>
     * @exception AccessException アクセス例外.
     */
    public void mount() throws AccessException ;
    
    /**
     * アンマウント処理.
     * <BR><BR>
     * 対象オブジェクトをアンマウントします.
     * <BR>
     * @exception AccessException アクセス例外.
     */
    public void unMount() throws AccessException ;
    
    /**
     * 最終アクセス時間取得.
     * <BR><BR>
     * 最終アクセス時間を取得します.
     * <BR>
     * @return long 最後にアクセスした時間が返されます.
     */
    public long getUpdateTime() ;
    
    /**
     * 生成チェック.
     * <BR><BR>
     * 生成されているかチェックします.
     * <BR>
     * @return boolean 生成チェック結果が返されます.<BR>
     *                 [true]が返された場合、生成されています.<BR>
     *                 [false]が返された場合、生成されていません.
     */
    public boolean isCreate() ;
    
    /**
     * 状態取得.
     * <BR><BR>
     * オブジェクトの状態を取得します.
     * <BR>
     * @return boolean オブジェクトの状態が返されます.<BR>
     *                 [true]が返された場合マウント状態です.<BR>
     *                 [false]が返された場合アンマウント状態です.
     */
    public boolean isState() ;
    
}

