/*
 * @(#)OutManager.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.io;

/**
 * 出力管理インターフェイス.
 * <BR><BR>
 * 出力管理を行うインターフェイスを提供します.
 *
 * @version 1.00, 2004/06/29
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public interface OutManager
{
    
    /**
     * クローズ処理.
     * <BR><BR>
     * 情報をクローズします.
     */
    public void close() ;
    
    /**
     * 情報フラッシュ.
     * <BR><BR>
     * 格納されている情報をフラッシュします.
     */
    public void flush() ;
    
    /**
     * 出力処理.
     * <BR><BR>
     * 対象の文字列情報を出力します.
     * <BR>
     * @param put 出力対象の文字列情報を設定します.
     */
    public void write( String put ) ;
    
    /**
     * 現在状況を取得します。
     * <BR><BR>
     * 現在のファイルオープン状況を取得します。
     * <BR>
     * @return boolean 現在のファイルオープン状況が格納されています。<BR>
     *                 [true]が返された場合、ファイルはオープンされています。<BR>
     *                 [false]が返された場合、ファイルはオープンされていません。
     */
    public boolean isOpen() ;
    
}

