/*
 * @(#)FileAccessException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.BaseException;

/**
 * ファイルアクセス例外.
 * <BR><BR>
 * ファイルアクセスに失敗した場合発生します。
 *  
 * @version 1.0.0 2003/10/27
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class FileAccessException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public FileAccessException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public FileAccessException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public FileAccessException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public FileAccessException(String message)
    {
        super(message) ;
    }
}
