/*
 * @(#)ConsoleIn.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

/**
 * コンソール入力.
 * <BR><BR>
 * コンソール入力オブジェクトを定義します.
 *  
 * @version 1.0.0 2005/09/21
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class ConsoleIn
{
    
    /**
     * コンソール入力オブジェクト.
     */
    private Reader m_in = null ;
    
    /**
     * コンストラクタ.
     */
    public ConsoleIn()
    {
        m_in = ConsoleIn.createIn() ;
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * <BR>
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.destroy() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public final void destroy()
    {
        try{
            m_in.close() ;
        }catch( Exception e ){
        }
        
        m_in = null ;
    }
    
    /**
     * コンソール入力文字列を取得.
     * <BR><RB>
     * コンソール入力文字列を取得します.
     * <BR>
     * @return String コンソール入力文字列を取得します.
     */
    public final String get()
    {
        String ret = null ;
        
        try{
            ret = ConsoleIn.getIn( m_in ) ;
        }catch( Exception e ){
            ret = "" ;
        }
        
        return ret ;
    }
    
    /**
     * コンソール入力生成.
     */
    private static final Reader createIn()
    {
        InputStreamReader is = null ;
        BufferedReader ret = null ;
        
        is = new InputStreamReader( System.in ) ;
        ret = new BufferedReader( is ) ;
        
        return ret ;
    }
    
    /**
     * コンソール入力情報取得.
     */
    private static final String getIn( Reader be )
        throws IOException
    {
        String ret = null ;
        
        try{
            ret = ( ( BufferedReader )be ).readLine() ;
        }catch( IOException io ){
            throw io ;
        }
        
        return ret ;
    }
}
