/*
 * @(#)StackTrace.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.exception;

/**
 * スタックトレース情報インターフェイス.
 *  
 * @version 1.0.0 2003/11/05
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface StackTrace
{
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 対象の情報をクリアします.
     */
    public void clear() ;
    
    /**
     * 格納パッケージ情報の取得.
     * <BR><BR>
     * 格納されているパッケージ情報を取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return String 格納されている情報が返されます.
     * @exception InputException 入力例外.
     */
    public String getPackage( int no )
        throws InputException ;
    
    /**
     * 格納オブジェクト情報の取得.
     * <BR><BR>
     * 格納されているオブジェクト情報を取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return String 格納されている情報が返されます.
     * @exception InputException 入力例外.
     */
    public String getObject( int no )
        throws InputException ;
    
    /**
     * 格納メソッド情報の取得.
     * <BR><BR>
     * 格納されているメソッド情報を取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return String 格納されている情報が返されます.
     * @exception InputException 入力例外.
     */
    public String getMethod( int no )
        throws InputException ;
    
    /**
     * 格納ライン情報の取得.
     * <BR><BR>
     * 格納されているライン情報を取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return String 格納されている情報が返されます.
     * @exception InputException 入力例外.
     */
    public String getLine( int no )
        throws InputException ;
    
    /**
     * 格納データ数を取得.
     * <BR><BR>
     * 格納されているデータ数を取得します.
     * <BR>
     * @return int 格納されているデータ数が返されます.
     */
    public int size() ;
    
}
