/*
 * @(#)NotSearchException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.exception;


/**
 * 検索結果で情報が存在しない例外検知.
 * <BR><BR>
 * 検索結果で、情報が存在しない場合の例外が検知されました.
 *  
 * @version 1.0.0 2003/11/04
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NotSearchException extends SettingException
{
    /**
     * コンタストラクタ.
     */
    public NotSearchException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotSearchException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotSearchException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NotSearchException(String message)
    {
        super(message) ;
    }
}
