/*
 * @(#)NotExistException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.exception;


/**
 * 情報が存在しない場合の例外処理.
 * <BR><BR>
 * 情報が存在しない場合、この例外が返されます.
 *  
 * @version 1.0.0 2003/10/31
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NotExistException extends SettingException
{
    /**
     * コンタストラクタ.
     */
    public NotExistException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotExistException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotExistException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NotExistException(String message)
    {
        super(message) ;
    }
}
