/*
 * @(#)ExistException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.exception;


/**
 * 情報が既に存在している場合の例外処理.
 * <BR><BR>
 * 情報が既に存在している場合、この例外が返されます.
 *  
 * @version 1.0.0 2003/10/31
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class ExistException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public ExistException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public ExistException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public ExistException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public ExistException(String message)
    {
        super(message) ;
    }
}
