/*
 * @(#)ExceptionUtil.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.exception;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

import com.JRcServer.commons.util.UtilCom;

/**
 * 例外ユーティリティ.
 *  
 * @version 1.0.0 2003/11/05
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class ExceptionUtil
{
    
    /**
     * スタックトレース行有効情報.
     */
    private static final String STACKTRACE_HEAD = "\tat " ;
    
    /**
     * スタックトレース行有効情報長.
     */
    private static final int STACKTRACE_HEAD_LENGTH =
        ExceptionUtil.STACKTRACE_HEAD.length() ;
    
    /**
     * スタックトレース情報長.
     * <BR><BR>
     * １つのスタックトレースにおける情報数が格納されています.
     */
    public static final int TRACE_NO_SIZE = 4 ;
    
    /**
     * スタックトレース情報 : パッケージ名.
     * <BR><BR>
     * スタックトレース情報取得処理[ExceptionUtil#getPauseStackTrace()]
     * での、格納順のパッケージ名の位置です.
     */
    public static final int TRACE_NO_PACKAGE = 0 ;
    
    /**
     * スタックトレース情報 : オブジェクト名.
     * <BR><BR>
     * スタックトレース情報取得処理[ExceptionUtil#getPauseStackTrace()]
     * での、格納順のオブジェクト名の位置です.
     */
    public static final int TRACE_NO_OBJECT = 1 ;
    
    /**
     * スタックトレース情報 : メソッド名.
     * <BR><BR>
     * スタックトレース情報取得処理[ExceptionUtil#getPauseStackTrace()]
     * での、格納順のメソッド名の位置です.
     */
    public static final int TRACE_NO_METHOD = 2 ;
    
    /**
     * スタックトレース情報 : エラーファイル名／行位置.
     * <BR><BR>
     * スタックトレース情報取得処理[ExceptionUtil#getPauseStackTrace()]
     * での、格納順のエラーファイル名／行位置の位置です.
     */
    public static final int TRACE_NO_FILE = 3 ;
    
    /**
     * コンストラクタ.
     */
    private ExceptionUtil()
    {}
    
    /**
     * スタックトレースを解析して、格納情報すべてを行単位で取得.
     * <BR><BR>
     * スタックトレース情報を解析して、格納情報すべてを行単位で取得します.
     * <BR>
     * @param exception スタックトレース取得対象の例外オブジェクトを設定します.
     * @return ArrayList スタックトレース情報が行単位で格納された内容が
     *                   返されます.<BR>
     *                   情報が存在しない場合[null]が返されます.
     */
    public static final ArrayList analysisAllStackTrace( Throwable exception )
    {
        
        String code = null ;
        PrintWriter fp = null ;
        ByteArrayOutputStream bin = null ;
        ArrayList ret = null ;
        
        if( exception == null ){
            return null ;
        }
        
        try{
            
            bin = new ByteArrayOutputStream() ;
            fp = new PrintWriter( bin ) ;
            exception.printStackTrace( (PrintWriter)fp ) ;
            fp.flush() ;
            
            code = new String( bin.toByteArray() ) ;
            
            ret = UtilCom.pauseEnter( code ) ;
            
        }catch( Exception t ){
            
            ret = null ;
            
        }finally{
            
            code = null ;
            fp = null ;
            bin = null ;
            
        }
        
        return ret ;
        
    }
    
    /**
     * スタックトレースを解析して、軌跡情報を行単位で取得.
     * <BR><BR>
     * スタックトレース情報を解析して、軌跡情報を行単位で取得します.
     * <BR>
     * @param exception スタックトレース取得対象の例外オブジェクトを設定します.
     * @return ArrayList スタックトレース軌跡情報が行単位で返されます.<BR>
     *                   情報が存在しない場合[null]が返されます.
     */
    public static final ArrayList analysisStackTrace( Throwable exception )
    {
        int i,j ;
        int len,len2 ;
        
        String code = null ;
        PrintWriter fp = null ;
        ByteArrayOutputStream bin = null ;
        ArrayList ret = null ;
        
        char[] chk = null ;
        
        if( exception == null ){
            return null ;
        }
        
        try{
            
            len2 = ExceptionUtil.STACKTRACE_HEAD.length() ;
            chk = new char[ len2 ] ;
            ExceptionUtil.STACKTRACE_HEAD.getChars( 0,len2,chk,0 ) ;
            
            bin = new ByteArrayOutputStream() ;
            fp = new PrintWriter( bin ) ;
            exception.printStackTrace( (PrintWriter)fp ) ;
            fp.flush() ;
            
            code = new String( bin.toByteArray() ) ;
            
            ret = UtilCom.pauseEnter( code ) ;
            len = ret.size() ;
            
            for( i = len - 1 ; i >= 0 ; i -- ){
                
                code = ( String )ret.get( i ) ;
                
                for( j = 0 ; j < len2 ; j ++ ){
                    
                    if( chk[ j ] != code.charAt( j ) ){
                        ret.remove( i ) ;
                        break ;
                    }
                }
                
            }
            
        }catch( Exception t ){
            
            ret = null ;
            
        }finally{
            
            code = null ;
            fp = null ;
            bin = null ;
            chk = null ;
            
        }
        
        return ret ;
        
    }
    
    /**
     * スタックトレース情報を区分けして取得.
     * <BR><BR>
     * スタックトレース情報を区分けして取得します.
     * <BR>
     * @param exception スタックトレース取得対象の例外オブジェクトを設定します.
     * @return StackTrace 区分けされた情報が返されます.
     */
    public static final StackTrace getPauseStackTrace( Throwable exception )
    {
        int i,j ;
        int len,len2,len3 ;
        int offset ;
        int sp,ep ;
        boolean parentFlg ;
        
        char chkChr ;
        
        ArrayList list = null ;
        ArrayList pause = null ;
        
        String check = null ;
        StringBuffer buf = null ;
        StackTraceCore ret = null ;
        
        String tmp = null ;
        String packName = null ;
        String objName = null ;
        String metName = null ;
        String lineInfo = null ;
        
        if( exception == null ){
            return null ;
        }
        
        offset = ExceptionUtil.STACKTRACE_HEAD_LENGTH ;
        
        try{
            
            list = ExceptionUtil.analysisStackTrace( exception ) ;
            
            buf = new StringBuffer() ;
            pause = new ArrayList() ;
            ret = new StackTraceCore() ;
            
            len = list.size() ;
            for( i = 0 ; i < len ; i ++ ){
                
                check = ( String )list.get( i ) ;
                len2 = check.length() ;
                
                for( j = offset,sp = -1,parentFlg = false ; j < len2 ; j ++ ){
                    
                    chkChr = check.charAt( j ) ;
                    
                    sp = ( sp == -1 ) ? j : sp ;
                    
                    if(
                        chkChr == '.' ||
                        chkChr == '('
                    )
                    {
                        
                        if( chkChr == '.' && parentFlg == false ){
                            ep = j ;
                        }else if( chkChr == '(' && parentFlg == false ){
                            ep = j ;
                            parentFlg = true ;
                        }else{
                            continue ;
                        }
                        
                        tmp = check.substring( sp,ep ) ;
                        
                        pause.add( tmp ) ;
                        
                        tmp = null ;
                        sp = -1 ;
                        ep = -1 ;
                        
                        if( parentFlg == true ){
                            break ;
                        }
                    }
                }
                
                len3 = pause.size() - 2 ;
                buf.delete( 0,buf.length() ) ;
                
                for( j = 0 ; j < len3 ; j ++ ){
                    buf.append( pause.get( j ) ) ;
                    if( j != len3-1 ){
                        buf.append( "." ) ;
                    }
                }
                
                packName = buf.toString() ;
                objName = ( String )pause.get( len3 ) ;
                metName = ( String )pause.get( len3+1 ) ;
                
                sp = ep = 0 ;
                for( j = len2-1,parentFlg = false ; j >= 0 ; j -- ){
                    
                    chkChr = check.charAt( j ) ;
                    
                    if(
                        chkChr == '(' ||
                        chkChr == ')'
                    )
                    {
                        
                        if( chkChr == ')' && parentFlg == false ){
                            parentFlg = true ;
                            ep = j+1 ;
                            continue ;
                        }else if( chkChr == '(' && parentFlg == true ){
                            sp = j ;
                        }else{
                            continue ;
                        }
                        
                        lineInfo = check.substring( sp,ep ) ;
                        
                        break ;
                        
                    }
                    
                }
                
                ret.add( packName,objName,metName,lineInfo ) ;
                pause.clear() ;
                
            }
            
        }catch( Exception t ){
            ret = null ;
        }finally{
            
            try{
                pause.clear() ;
            }catch( Exception t1 ){
            }
            
            buf = null ;
            pause = null ;
        }
        
        return ret ;
    }
    
}
