/*
 * @(#)JRcServerDef.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.def;

/**
 * JRcServerパッケージ定義.
 *  
 * @version 2005/09/12
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class JRcServerDef
{
    /**
     * シングルトン.
     */
    private static final JRcServerDef SNGL = new JRcServerDef() ;
    
    /**
     * コンストラクタ.
     */
    private JRcServerDef(){}
    
    /**
     * オブジェクトを取得.
     * <BR><BR>
     * オブジェクト情報を取得します.
     * <BR>
     * @return JRcServerDef オブジェクト情報が返されます.
     */
    public static final JRcServerDef getInstance()
    {
        return SNGL ;
    }
    
    /**
     * JRcCommons名の取得.
     * <BR><BR>
     * JRcCommons名を取得します.
     * <BR>
     * @return String JRcCommons名が返されます.
     */
    public final String getName()
    {
        return "JRcCommons" ;
    }
    
    /**
     * JRcCommonsバージョン名を取得.
     * <BR><BR>
     * JRcCommonsバージョン名を取得します.
     * <BR>
     * @return String JRcCommonsバージョン名が返されます.
     */
    public final String getVersion()
    {
        return "1.00" ;
    }
    
    /**
     * JRcCommons最終日付を取得.
     * <BR><BR>
     * JRcCommons最終日付を取得します.
     * <BR>
     * @return String JRcCommons最終日付が返されます.
     */
    public final String getLastUpdate()
    {
        return "2006/04/20" ;
    }
    
    /**
     * JRcCommons作成者を取得.
     * <BR><BR>
     * JRcCommons作成者を取得します.
     * <BR>
     * @return String JRcCommons作成者が返されます.
     */
    public final String getMaker()
    {
        return "Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved." ;
    }
    
}

