/*
 * @(#)MD5.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.conv;

import java.io.InputStream;

import com.JRcServer.commons.exception.InputException;

/**
 * バイナリ情報をMD5に変換.
 * <BR><BR>
 * バイナリ情報をMD5に変換します.
 *
 * @version 1.00, 2005/04/21
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public class MD5
{
    
    /**
     * ダイジェストタイプ.
     */
    private static final String DIGEST_TYPE = "MD5" ;
    
    /**
     * バイナリ情報をMD5に変換します.
     * <BR><BR>
     * バイナリ情報をMD5に変換します.
     * <BR>
     * @param bin 変換対象のバイナリ情報を設定します.
     * @param offset 変換対象バイナリの変換オフセット値を設定します.
     * @param length 変換対象バイナリの変換長を設定します.
     * @return byte[] 変換されたMD5情報が返されます.
     * @throws InputException 入力例外.
     */
    public static final byte[] convert( InputStream stream )
        throws InputException
    {
        return Digest.convert( DIGEST_TYPE,stream ) ;
    }
    
    /**
     * バイナリ情報をMD5に変換します.
     * <BR><BR>
     * バイナリ情報をMD5に変換します.
     * <BR>
     * @param bin 変換対象のバイナリ情報を設定します.
     * @return byte[] 変換されたMD5情報が返されます.
     * @throws InputException 入力例外.
     */
    public static final byte[] convertBinary( byte[] bin )
        throws InputException
    {
        return Digest.convertBinary( DIGEST_TYPE,bin ) ;
    }
    
    /**
     * バイナリ情報をMD5に変換します.
     * <BR><BR>
     * バイナリ情報をMD5に変換します.
     * <BR>
     * @param bin 変換対象のバイナリ情報を設定します.
     * @param length 変換対象バイナリの変換長を設定します.
     * @return byte[] 変換されたMD5情報が返されます.
     * @throws InputException 入力例外.
     */
    public static final byte[] convertBinary( byte[] bin,int length )
        throws InputException
    {
        return Digest.convertBinary( DIGEST_TYPE,bin,length ) ;
    }
    
    /**
     * バイナリ情報をMD5に変換します.
     * <BR><BR>
     * バイナリ情報をMD5に変換します.
     * <BR>
     * @param bin 変換対象のバイナリ情報を設定します.
     * @param offset 変換対象バイナリの変換オフセット値を設定します.
     * @param length 変換対象バイナリの変換長を設定します.
     * @return byte[] 変換されたMD5情報が返されます.
     * @throws InputException 入力例外.
     */
    public static final byte[] convertBinary( byte[] bin,int offset,int length )
        throws InputException
    {
        return Digest.convertBinary( DIGEST_TYPE,bin,offset,length ) ;
    }
    
    /**
     * バイナリ情報をMD5に変換します.
     * <BR><BR>
     * バイナリ情報をMD5に変換します.
     * <BR>
     * @param bin 変換対象のバイナリ情報を設定します.
     * @return String 変換されたMD5情報が返されます.
     * @throws InputException 入力例外.
     */
    public static final String convert( byte[] bin )
        throws InputException
    {
        return Digest.convert( DIGEST_TYPE,bin ) ;
    }
    
    /**
     * バイナリ情報をMD5に変換します.
     * <BR><BR>
     * バイナリ情報をMD5に変換します.
     * <BR>
     * @param bin 変換対象のバイナリ情報を設定します.
     * @param length 変換対象バイナリの変換長を設定します.
     * @return String 変換されたMD5情報が返されます.
     * @throws InputException 入力例外.
     */
    public static final String convert( byte[] bin,int length )
        throws InputException
    {
        return Digest.convert( DIGEST_TYPE,bin,length ) ;
    }
    
    /**
     * バイナリ情報をMD5に変換します.
     * <BR><BR>
     * バイナリ情報をMD5に変換します.
     * <BR>
     * @param bin 変換対象のバイナリ情報を設定します.
     * @param offset 変換対象バイナリの変換オフセット値を設定します.
     * @param length 変換対象バイナリの変換長を設定します.
     * @return String 変換されたMD5情報が返されます.
     * @throws InputException 入力例外.
     */
    public static final String convert( byte[] bin,int offset,int length )
        throws InputException
    {
        return Digest.convert( DIGEST_TYPE,bin,offset,length ) ;
    }
    
    private MD5(){}
}

