/*
 * @(#)Asc64Def.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.conv;

/**
 * ASCII情報からASC64変換Defineオブジェクト.
 * <BR><BR>
 * ASCII情報からASC64変換用定数定義をサポートします.
 * <BR>
 * また、ASC64で対応されているコード内容は、以下の通りです.
 * <BR>
 * [0 - 9]<BR>
 * [a - z]<BR>
 * [A - Z]<BR>
 * [-]<BR>
 * [+]
 *
 * @version 1.00, 2004/01/04
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
class Asc64Def
{
    
    /**
     * 変換処理内容範囲外定数.
     */
    public static final int NOT_ASC_64 = -1 ;
    
    /**
     * ASC64 -> ASCII への変換定数.
     * <BR><BR>
     * 所定のASC64から、アスキーコードへの
     * 変換定数をサポートします.
     * <BR>
     * ※また、改行情報はサポートしていません.
     */
    public static final String[] ASC64_BY_ASC = {
        "z","V","I","-","2","m","r","F","o","6","A","+","1","8","x","j",
        "c","4","C","u","f","L","Q","9","S","X","h","0","N","w","J","7",
        "G","k","a","B","W","n","s","3","K","g","R","E","U","l","v","Y",
        "H","p","d","M","5","P","y","D","b","i","T","Z","t","O","q","e"
    } ;
    
    /**
     * ASCII -> ASC64への変換定数.
     * <BR><BR>
     * アスキーコードから、所定のASC64変換定数をサポートします.
     * <BR>
     * @param code 変換元のキャラクターを設定します.
     * @return int 変換されたコードが返されます.
     * ※また、改行情報はサポートしていません.
     * また、戻り値が -1 の場合その対象情報は存在しません.
     */
    public static final int convertASC_BY_ASC64( char code )
    {
        switch( code ){
            case 'z' : return 0 ;
            case 'V' : return 1 ;
            case 'I' : return 2 ;
            case '-' : return 3 ;
            case '2' : return 4 ;
            case 'm' : return 5 ;
            case 'r' : return 6 ;
            case 'F' : return 7 ;
            case 'o' : return 8 ;
            case '6' : return 9 ;
            case 'A' : return 10 ;
            case '+' : return 11 ;
            case '1' : return 12 ;
            case '8' : return 13 ;
            case 'x' : return 14 ;
            case 'j' : return 15 ;
            case 'c' : return 16 ;
            case '4' : return 17 ;
            case 'C' : return 18 ;
            case 'u' : return 19 ;
            case 'f' : return 20 ;
            case 'L' : return 21 ;
            case 'Q' : return 22 ;
            case '9' : return 23 ;
            case 'S' : return 24 ;
            case 'X' : return 25 ;
            case 'h' : return 26 ;
            case '0' : return 27 ;
            case 'N' : return 28 ;
            case 'w' : return 29 ;
            case 'J' : return 30 ;
            case '7' : return 31 ;
            case 'G' : return 32 ;
            case 'k' : return 33 ;
            case 'a' : return 34 ;
            case 'B' : return 35 ;
            case 'W' : return 36 ;
            case 'n' : return 37 ;
            case 's' : return 38 ;
            case '3' : return 39 ;
            case 'K' : return 40 ;
            case 'g' : return 41 ;
            case 'R' : return 42 ;
            case 'E' : return 43 ;
            case 'U' : return 44 ;
            case 'l' : return 45 ;
            case 'v' : return 46 ;
            case 'Y' : return 47 ;
            case 'H' : return 48 ;
            case 'p' : return 49 ;
            case 'd' : return 50 ;
            case 'M' : return 51 ;
            case '5' : return 52 ;
            case 'P' : return 53 ;
            case 'y' : return 54 ;
            case 'D' : return 55 ;
            case 'b' : return 56 ;
            case 'i' : return 57 ;
            case 'T' : return 58 ;
            case 'Z' : return 59 ;
            case 't' : return 60 ;
            case 'O' : return 61 ;
            case 'q' : return 62 ;
            case 'e' : return 63 ;
            default : return NOT_ASC_64 ;
        }
        
    }
    
    /**
     * コンストラクタ.
     */
    private Asc64Def()
    {}
    
}

