/*
 * @(#)JRcResult.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.client ;

import java.io.InputStream;

import com.JRcServer.JRcResponseBean;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.BinResourceInputStream;

/**
 * JRcResultオブジェクト.
 * <BR><BR>
 * JRcClient結果内容実装オブジェクト.
 *  
 * @version 2006/09/10
 * @author  masahito suzuki
 * @since   JRcClient 1.00
 */
class JRcResultImple implements JRcResult {
    
    /**
     * 情報オブジェクト.
     */
    private BinResource binary = null ;
    
    /**
     * キャラクタセット.
     */
    private String charset = null ;
    
    /**
     * MimeType.
     */
    private String mimeType = null ;
    
    /**
     * 結果コード.
     */
    private int result = -1 ;
    
    /**
     * コンストラクタ.
     */
    private JRcResultImple() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * JRcResponseBeanを設定してオブジェクトを生成します.
     * <BR>
     * @param bean 対象のJRcResponseBeanを設定します.
     */
    public JRcResultImple( JRcResponseBean bean ) {
        
        this.binary = bean.getBinary() ;
        this.charset = bean.getCharset() ;
        this.mimeType = bean.getMimeType() ;
        this.result = bean.getResult() ;
        
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクト情報を破棄します.
     */
    public void close() {
        
        if( this.binary != null ) {
            this.binary.clear() ;
        }
        
        this.binary = null ;
        this.charset = null ;
        this.mimeType = null ;
        this.result = -1 ;
        
    }
    
    /**
     * InputStreamを取得.
     * <BR><BR>
     * 処理結果の内容をInputStreamで取得します.
     * <BR>
     * @return InputStream 処理結果内容が返されます.
     */
    public InputStream getInputStream() {
        
        InputStream ret = null ;
        
        if( this.binary != null ) {
            try {
                ret = new BinResourceInputStream( this.binary ) ;
            } catch( Exception e ) {
                ret = null ;
            }
        }
        
        return ret ;
        
    }
    
    /**
     * データ長を取得.
     * <BR><BR>
     * 処理結果のデータ長を取得します.
     * <BR>
     * @return int データ長が返されます.
     */
    public int getSize() {
        
        if( this.binary != null ) {
            return this.binary.size() ;
        }
        
        return 0 ;
    }
    
    /**
     * キャラクタセットを取得.
     * <BR><BR>
     * 処理結果のキャラクタセットが返されます.
     * <BR>
     * @return String キャラクタセットが返されます.
     */
    public String getCharset() {
        
        return this.charset ;
        
    }
    
    /**
     * Mimeタイプを取得.
     * <BR><BR>
     * 処理結果のMimeタイプが返されます.
     * <BR>
     * @return String Mimeタイプが返されます.
     */
    public String getMimeType() {
        
        return this.mimeType ;
        
    }
    
    /**
     * 戻り値コードを取得.
     * <BR><BR>
     * 処理結果の戻り値コードが返されます.
     * <BR>
     * @return int 戻り値コードが返されます.
     */
    public int getResult() {
        
        return this.result ;
        
    }
    
}

