/*
 * @(#)JRcResult.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.client ;

import java.io.InputStream;

/**
 * JRcResult.
 * <BR><BR>
 * JRcClient結果内容インターフェイス.
 *  
 * @version 2006/09/10
 * @author  masahito suzuki
 * @since   JRcClient 1.00
 */
public interface JRcResult {
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクト情報を破棄します.
     */
    public void close() ;
    
    /**
     * InputStreamを取得.
     * <BR><BR>
     * 処理結果の内容をInputStreamで取得します.
     * <BR>
     * @return InputStream 処理結果内容が返されます.
     */
    public InputStream getInputStream() ;
    
    /**
     * データ長を取得.
     * <BR><BR>
     * 処理結果のデータ長を取得します.
     * <BR>
     * @return int データ長が返されます.
     */
    public int getSize() ;
    
    /**
     * キャラクタセットを取得.
     * <BR><BR>
     * 処理結果のキャラクタセットが返されます.
     * <BR>
     * @return String キャラクタセットが返されます.
     */
    public String getCharset() ;
    
    /**
     * Mimeタイプを取得.
     * <BR><BR>
     * 処理結果のMimeタイプが返されます.
     * <BR>
     * @return String Mimeタイプが返されます.
     */
    public String getMimeType() ;
    
    /**
     * 戻り値コードを取得.
     * <BR><BR>
     * 処理結果の戻り値コードが返されます.
     * <BR>
     * @return int 戻り値コードが返されます.
     */
    public int getResult() ;
    
}

