/*
 * @(#)JRcClient.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.client ;

/**
 * JRcClient-session管理.
 * <BR><BR>
 * JRcClientのsessionを管理します.
 *  
 * @version 2006/09/10
 * @author  masahito suzuki
 * @since   JRcClient 1.00
 */
public interface JRcClientSession {
    
    /**
     * applicationName を取得.
     * <BR><BR>
     * @return applicationName が返されます.
     */
    public String getApplicationName() ;
    
    /**
     * hostName を取得.
     * <BR><BR>
     * @return hostName が返されます.
     */
    public String getHostName() ;
    
    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() ;
    
    /**
     * sessionID を取得.
     * <BR><BR>
     * @return sessionID が返されます.
     */
    public long getSessionID() ;
    
    /**
     * オブジェクト有効チェック.
     * <BR><BR>
     * オブジェクト有効チェックを行います.
     * <BR>
     * @return boolean チェック結果が返されます.
     */
    public boolean isUseObject() ;
    
}

