/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.Date;

public abstract class ResourceHolderSupport {
    private boolean synchronizedWithTransaction;
    private boolean rollbackOnly;
    private Date deadline;

    public void setSynchronizedWithTransaction(boolean synchronizedWithTransaction) {
        this.synchronizedWithTransaction = synchronizedWithTransaction;
    }

    public boolean isSynchronizedWithTransaction() {
        return this.synchronizedWithTransaction;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setTimeoutInSeconds(int seconds) {
        this.setTimeoutInMillis(seconds * 1000);
    }

    public void setTimeoutInMillis(long millis) {
        this.deadline = new Date(System.currentTimeMillis() + millis);
    }

    public boolean hasTimeout() {
        return this.deadline != null;
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public int getTimeToLiveInSeconds() {
        double diff = (double)this.getTimeToLiveInMillis() / 1000.0;
        return (int)Math.ceil(diff);
    }

    public long getTimeToLiveInMillis() {
        if (this.deadline == null) {
            throw new IllegalStateException("No timeout specified for this resource holder");
        }
        long timeToLive = this.deadline.getTime() - System.currentTimeMillis();
        return timeToLive >= 0L ? timeToLive : 0L;
    }

    public void clear() {
        this.synchronizedWithTransaction = false;
        this.rollbackOnly = false;
        this.deadline = null;
    }
}

