/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ServletForwardingController
extends AbstractController
implements BeanNameAware {
    private String servletName;
    private String beanName;

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected void initApplicationContext() {
        if (this.servletName == null) {
            this.servletName = this.beanName;
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestDispatcher rd = this.getServletContext().getNamedDispatcher(this.servletName);
        if (rd == null) {
            throw new ServletException("No servlet with name '" + this.servletName + "' defined in web.xml");
        }
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            rd.include((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Included servlet [" + this.servletName + "] in ServletForwardingController '" + this.beanName + "'"));
            }
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarded to servlet [" + this.servletName + "] in ServletForwardingController '" + this.beanName + "'"));
            }
        }
        return null;
    }
}

