/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.springframework.beans.PropertyValue;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ServletRequestDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    private String fieldMarkerPrefix = "_";
    private boolean bindEmptyMultipartFiles = true;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ServletRequestDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public void bind(ServletRequest request) {
        ServletRequestParameterPropertyValues pvs = new ServletRequestParameterPropertyValues(request);
        if (this.fieldMarkerPrefix != null) {
            PropertyValue[] pvArray = pvs.getPropertyValues();
            for (int i = 0; i < pvArray.length; ++i) {
                PropertyValue pv = pvArray[i];
                if (!pv.getName().startsWith(this.fieldMarkerPrefix)) continue;
                String field = pv.getName().substring(this.fieldMarkerPrefix.length());
                if (!this.getBeanWrapper().isWritableProperty(field) || pvs.contains(field)) continue;
                Class type = this.getBeanWrapper().getPropertyType(field);
                if (type != null && Boolean.TYPE.equals(type) || (class$java$lang$Boolean == null ? ServletRequestDataBinder.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(type)) {
                    pvs.addPropertyValue(field, Boolean.FALSE);
                    continue;
                }
                if (type != null && type.isArray()) {
                    pvs.addPropertyValue(field, Array.newInstance(type.getComponentType(), 0));
                    continue;
                }
                pvs.addPropertyValue(field, null);
            }
        }
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            Iterator it = fileMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                MultipartFile value = (MultipartFile)fileMap.get(key);
                if (!this.bindEmptyMultipartFiles && value.isEmpty()) continue;
                pvs.addPropertyValue(key, value);
            }
        }
        this.bind(pvs);
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getErrors().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getErrors().getObjectName() + "'", this.getErrors());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

