#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use CGI;

use Lib::Logger;
use Lib::String;
use Lib::Filter;
use Lib::Mail;
use Lib::Ping;
use Lib::DateTime;
use Lib::User;
use Lib::Topic;
use Lib::Trackback;
use Lib::Conf;
use Lib::Language;

my $conf = Lib::Conf->new();
my $logger = Lib::Logger->new();

my $cgi = CGI->new();

my $string = Lib::String->new();
my $language = Lib::Language->new();

# トピックID
my $topicid = get_id($cgi);
if ($topicid !~ /\A[0-9]+\z/) {
    trackback_error($language->get_trackbackerror('illegal-parameter'));
}
$logger->write("rcvtb.cgi - topicid:$topicid"); # for debug

# エントリのタイトル
my $title = $cgi->param('title');
if ($title eq '') {
    trackback_error($language->get_trackbackerror('illegal-title'));
}

# エントリの要約
my $excerpt = $cgi->param('excerpt');
if ($excerpt eq '') {
    trackback_error($language->get_trackbackerror('illegal-excerpt'));
}

# ブログ名
my $blogname = $cgi->param('blog_name');
if ($blogname eq '') {
    trackback_error($language->get_trackbackerror('illegal-blogname'));
}
# エントリのURL
my $url = $cgi->param('url');
if ($url eq '') {
    trackback_error($language->get_trackbackerror('illegal-url'));
}

## 文字コードの種類を取得
#my $code = $string->get_encode("$title $excerpt $blogname");
#$logger->write("rcvtb.cgi code:$code");    # for debug
# 文字コードをUTF8に変換(euc,sjis,jis以外は原則utf8とみなす)
#if ($code eq 'euc' || $code eq 'sjis' || $code eq 'jis') {
#    $title = $string->convert($title, $code, 'utf8');
#    $excerpt = $string->convert($excerpt, $code, 'utf8');
#    $blogname = $string->convert($blogname, $code, 'utf8');
#    $url = $string->convert($url, $code, 'utf8');
#}

# UTF-8に変換
$title = $string->any2utf8($title);
$excerpt = $string->any2utf8($excerpt);
$blogname = $string->any2utf8($blogname);

# 要約が半角英数のみの場合は拒否
my $langcode = $language->get_langcode();
if (($langcode eq 'ja') && ($excerpt =~ /\A[\x20-\x7E\r\n]+\z/)) {
    trackback_error($language->get_trackbackerror('deny-trackback'));
}

# 拒否リストに登録されていないかチェック
my $ipaddr = $ENV{'REMOTE_ADDR'};
my $filter = Lib::Filter->new();
if ($filter->check_filter("$ipaddr $url $title $blogname")) {
    trackback_error($language->get_trackbackerror('deny-trackback'));
}

# 要約の長さを調整
$excerpt = $string->cut($excerpt, $conf->get_excerpt_length());

$title =~ s/,/enc_conma/g;
$excerpt =~ s/,/enc_conma/g;
$blogname =~ s/,/enc_conma/g;
$url =~ s/,/enc_conma/g;

my $topic = Lib::Topic->new();
$topic->load($topicid, 1);
my $topic_status = $topic->get_status();
if ($topic_status != 1 && $topic_status != 3) {
    trackback_error($language->get_trackbackerror('deny-trackback'));
}

my $editor = $topic->get_editor();

# トラックバックIDの設定
my @trackbacks = $topic->get_trackbacks();
my $trackbackid = 0;
if (scalar(@trackbacks) > 0) {
    $trackbackid = (split(/\,/, $trackbacks[$#trackbacks]))[0];
}
$trackbackid++;

my $dt = Lib::DateTime->new();
my $recvdate = $dt->local_datetime(0);

my $status = 1;
if ($topic_status == 3) {
    $status = 2;  # 承認待ちステータスを設定
}

my $trackbackdata = "$trackbackid,$status,$recvdate,$url,$blogname,$title,$excerpt,$ipaddr";
push @trackbacks, $trackbackdata;
$topic->set_trackbacks(@trackbacks);

my $point = $topic->get_point() + $conf->get_normal_point();
$topic->set_point($point);
$topic->update();

my $trackback = Lib::Trackback->new();
$trackback->add($topicid, $trackbackid, $title, $recvdate, $excerpt);

$topic->get_html($conf->get_static_html(), 0);

my $docrootdir = $conf->get_docroot_dir();
my $topictitle = $topic->get_title();
my $topicurl = "$docrootdir/?func=detail&id=$topicid";

$title =~ s/enc_conma/,/g;
$excerpt =~ s/enc_conma/,/g;
$blogname =~ s/enc_conma/,/g;
$url =~ s/enc_conma/,/g;

my $trackbackinfo = $language->get_message('trackback-info');
my $trackbackinfobody = $language->get_message('trackback-infobody');
$trackbackinfo     =~ s/\$TOPICTITLE\$/$topictitle/g;
$trackbackinfobody =~ s/\$TOPICTITLE\$/$topictitle/g;

my $ipaddrlabel = $language->get_static('ip-address');
my $blognamelabel = $language->get_static('blog-name');
my $titlelabel = $language->get_static('title');
my $urllabel = $language->get_static('url');
my $excerptlabel = $language->get_static('excerpt');

my $subject = $trackbackinfo;
my $body = <<"END_BODY";
$trackbackinfobody
$topicurl

----------

$ipaddrlabel :
$ipaddr

$blognamelabel :
$blogname

$titlelabel :
$title

urllabel :
$url

$excerptlabel：
$excerpt

----------
END_BODY

my $mail = Lib::Mail->new();
my $mailaddr = '';

# send trackback information mail to topic editor.
if ($editor ne '') {
    my $user = Lib::User->new();
    $user->load($editor);
    $mailaddr = $user->get_mailaddr();
    $mail->send($subject, $body, $mailaddr);
}
# send trackback information mail to webmaster.
my $adminaddr = $conf->get_admin_address();
if ($conf->get_notify_mail() && $adminaddr ne $mailaddr) {
    $mail->send($subject, $body, $adminaddr);
}

# return result
my $result =  <<"END_RESULT";
<?xml encoding="utf-8"?>
<response>
<error>0</error>
<message>Thanks for your ping to $topicurl</message>
</response>
END_RESULT

print $cgi->header('text/xml'), $result;

exit;

sub get_id {
    my $cgi = shift;

    my $path_info = $cgi->path_info();
    if ($path_info eq '') {
        $path_info = $ENV{REQUEST_URI};
    }
    $path_info && $path_info =~ m!(\w+)$! && return $1;

    return;
}

sub trackback_error {
    my $msg = shift;

    my $result = <<"END_RESULT";
<?xml encoding="utf-8"?>
<response>
<error>1</error>
<message>$msg</message>
</response>
END_RESULT

    print $cgi->header('text/xml'), $result;

    exit;

}
