#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Util;

use strict;
use warnings;

use Lib::Logger;
use Lib::String;

my $logger = Lib::Logger->new();

# コンストラクタ
sub new {
    my $self = {};

    use Lib::Conf;
    my $conf = Lib::Conf->new();

    $self->{excerpt_length} = $conf->get_excerpt_length();

    bless($self);
    return $self;
}

# HTMLタグを無効化
sub tag_invalidate {
    my $self = shift;
    my $text = shift;

    $text =~ s/&/&amp;/g;
    $text =~ s/"/&quot;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;

    return $text;
}

# URLをリンクに変換して返す
sub url_link {
    my $self = shift;
    my $url = shift;
    my $target = shift;

    my $pattern = "s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+";
    $url =~ s/($pattern)/<a href="$1" $target>$1<\/a>/g;

    return $url;
}

# URLからコンテンツのタイトルと引用文を取得
sub get_blockquote {
    my $self = shift;
    my $url = shift;

    use LWP::Simple;
    my $content = LWP::Simple::get($url);
    my $string = Lib::String->new();

    # UTF-8に変換
    $content = $string->any2utf8($content);

    my $blockquote = '';
    my $pattern = "<meta.*name=\"description\".*content=\"(.+)?\".*?>";
    if ($content =~ m/$pattern/i) {
        $blockquote = $1;
    }

    $content =~ s/\r?\n//g;
    $pattern = "<title.*?>(.*)</title>";
    my $title = '';
    if($content =~ m/$pattern/i) {
        $title = $1;
    }

    my @element = ($title, $blockquote);
    return @element;
}

1;
# End of Util.pm
