#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Error;

use strict;
use warnings;

use Lib::Logger;
use Lib::Language;

my $logger = Lib::Logger->new();

# コンストラクタ
sub new {
  my $self = {};
  bless($self);
  return $self;
}

# エラーメッセージを表示してプログラムを終了する
sub print_error {
    my $self = shift;
    my $code = shift;

    my $language = Lib::Language->new();
    my $message = $language->get_systemerror($code); 
    $logger->write($message);

    my $html = $self->_gen_html('Internal Server Error', $message);

    print "Status: 500 Internal Server Error\n";
    print "Content-Type: text/html\n\n";
    print $html;

    exit;
}

# エラーページの生成
sub _gen_html() {
    my $self = shift;
    my ($title, $message) = @_;

    my $html = <<"END_HTML";
<html>
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <title>$title</title>
</head>
<body bgcolor="#FFFFFF">
    <h2>$title</h2>
    <p><font size="+1"><strong>$message</strong></font></p>
</body>
</html>
END_HTML

}

1;
# End of Error.pm
