#!/usr/bin/perl

use strict;
use warnings;

use CGI;
my $cgi = CGI->new();

my $q = $cgi->param('querystr');
$q =~ s/^[ \t]+//g;
$q =~ s/(\W)/'%' . unpack('H2', $1)/eg;

my $target = $cgi->param('target');
if ($target eq '') {
    use Lib::App::Conf;
    my $conf = Lib::App::Conf->new();
    $target = $conf->get_default_target();
}

my $pageurl = "index.cgi?target=$target";
if ($q ne '') {
    $pageurl .= "&q=$q";

}

print "Status: 301 Moved Permanently\n";
print "Location: $pageurl", "\n\n";
