#!/usr/bin/perl
use strict;
use warnings;

my $data_dir = 'data';
my $system_dir = 'system';

# gsbNf[^̕ϊ
my $counterfile = "$system_dir/topiccounter.txt";
open my $counterfh, '<', $counterfile;
my $counter = <$counterfh>;
chop $counter;
close $counterfh;

for my $i (0..$counter) {
    my $id = $i;

    # gsbNf[^
    my $datafile = "$data_dir/$id" . "tp.data";
    open my $infh, '<', $datafile;
    my $datarec = <$infh>;
    chop $datarec;
    close $infh;
    my ($topicid,$lastdate,$status,$editor,$title,$outline,$text,$psnum,$commentnum,$linknum,$tbnum,$flienum,$ad1,$ad2,$ad3,$point) = split(/\,/, $datarec);

    $outline =~ s/<br>/<br \/>enc_crlf/g;
    $text =~ s/<br>/<br \/>enc_crlf/g;

    $ad1 =~ s/<br>/enc_crlf/g;
    $ad2 =~ s/<br>/enc_crlf/g;
    $ad3 =~ s/<br>/enc_crlf/g;

    # ^Of[^
    my $tagfile = "$data_dir/$id" . "tg.data";
    my $keyword = '';
    if (-f $tagfile) {
        open my $tagfh, '<', $tagfile;
        $keyword = <$tagfh>;
        chop $keyword;
        close $tagfh;
    }

    open my $outfh, '>', $datafile;
    print $outfh "0,$topicid,$lastdate,$status,$editor,$title,$outline,$text,$psnum,$commentnum,$tbnum,$linknum,$flienum,";
    print $outfh ",$ad3,$ad1,$point,$keyword,\n";

    # ǋLf[^
    my $psfile = "$data_dir/$id" . "ps.data";
    if (-f $psfile) {
        open my $psfh, '<', $psfile;
        while (my $datarec = <$psfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($psid,$lastdate,$editor,$title,$text) = split(/\,/, $datarec);
                if ($psid != 0) {
                    $text =~ s/<br>/<br \/>/g;
                    print {$outfh} "2,$psid,$lastdate,$editor,$title,$text\n";
                }
            }
        }
        close $psfh;
    }

    # Ytt@Cf[^
    my $atfile = "$data_dir/$id" . "af.data";
    if (-f $atfile) {
        open my $atfh, '<', $atfile;
        while (my $datarec = <$atfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($fileid,$filename,$fileext,$filesize,$status,$lastdate,$lastuser) = split(/\,/, $datarec);
                print {$outfh} "3,$fileid,$filename,$fileext,$filesize,$lastdate,$lastuser\n";
            }
        }
        close $atfh;
    }

    # ֘ANf[^
    my $linkfile = "$data_dir/$id" . "ln.data";
    if (-f $linkfile) {
        open my $linkfh, '<', $linkfile;
        while (my $datarec = <$linkfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($linkid,$title,$url,$summary) = split(/\,/, $datarec);
                if ($linkid != 0) {
                    $summary =~ s/<br>/<br \/>/g;
                    print {$outfh} "4,$linkid,$title,$url,$summary\n";
                }
            }
        }
        close $linkfh;
    }

    # Rgf[^
    my $commentfile = "$data_dir/$id" . "cm.data";
    if (-f $commentfile) {
        open my $commentfh, '<', $commentfile;
        while (my $datarec = <$commentfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($commentid,$postdate,$author,$mailaddr,$hpurl,$commenttext,$postipaddr,$evaluate) = split(/\,/, $datarec);
                if ($commentid != 0) {
                    $commenttext =~ s/<br>/<br \/>/g;
                    print {$outfh} "5,$commentid,1,$postdate,$author,$mailaddr,$hpurl,$commenttext,$evaluate,$postipaddr\n";
                }
            }
        }
        close $commentfh;
    }

    # gbNobNf[^
    my $trackbackfile = "$data_dir/$id" . "tb.data";
    if (-f $trackbackfile) {
        open my $trackbackfh, '<', $trackbackfile;
        while (my $datarec = <$trackbackfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($tbid,$recvdate,$url,$blogname,$entrytitle,$entryexcerpt,$tbipaddr) = split(/\,/, $datarec);
                if ($tbid != 0) {
                    print {$outfh} "6,$tbid,1,$recvdate,$url,$blogname,$entrytitle,$entryexcerpt,$tbipaddr\n";
                }
            }
        }
        close $trackbackfh;
    }

    close $outfh;
}

# ubN}[Nf[^̕ϊ
my $bmcounterfile = "$system_dir/bmcounter.txt";
open my $bmcounterfh, '<', $bmcounterfile;
my $bmcounter = <$bmcounterfh>;
chop $bmcounter;
close $bmcounterfh;

for my $i (1..$bmcounter) {
    my $id = $i;

    # ubN}[Nf[^
    my $datafile = "$data_dir/bookmark/$id" . "bm.data";
    if (-f $datafile) {

        open my $infh, '<', $datafile;
        my $datarec = <$infh>;
        chop $datarec;
        close $infh;
        my ($bmid,$title,$url,$summary,$registrant,$datetime,$tags,$point) = split(/\,/, $datarec);

        open my $outfh, '>', $datafile;
        print {$outfh} "0,$bmid,$title,$url,$summary,$registrant,$datetime,$tags,$point\n";

        # ubN}[NRgf[^
        my $commentfile = "$data_dir/bookmark/$id" . "bc.data";
        if (-f $commentfile) {
            open my $commentfh, '<', $commentfile;
            while (my $datarec = <$commentfh>) {
                chop $datarec;
                my ($commentid,$postdate,$author,$mailaddr,$hpurl,$commenttext,$postipaddr,$evaluate) = split(/\,/, $datarec);
                if ($commentid != 0) {
                    $commenttext =~ s/<br>/<br \/>/g;
                    print {$outfh} "2,$commentid,1,$postdate,$author,$mailaddr,$hpurl,$commenttext,$evaluate,$postipaddr\n";
                }
            }
            close $commentfh;
        }

        close $outfh;
    }
}

# L[[hfBNg̍쐬
my $keyword_dir = "$data_dir/keyword";
mkdir $keyword_dir, 0777;

# L[[hJE^[t@C̃l[
rename "$system_dir/tagcounter.txt", "$system_dir/keywordcounter.txt";

# L[[hf[^̕ϊ
my $tagfile = "$data_dir/tag/tagindex.data";
if (-f $tagfile) {
    open my $tagfh, '<', $tagfile;

    my $keywordfile = "$data_dir/keyword/keyword.data";
    open my $keywordfh, '>', $keywordfile;

    while (my $datarec = <$tagfh>) {
        chop($datarec);
        if ($datarec ne '') {
            print {$keywordfh} "$datarec,,,,,,\n";
        }
    }

    close $keywordfh;

    close $tagfh;
}

# [U[fBNg̍쐬
mkdir "$system_dir/user", 0777;

# [U[f[^̕ϊ
my $listfile = "$system_dir/userlist.txt";
if (-f $listfile) {
    open my $listfh, '<', $listfile;

    while (my $datarec = <$listfh>) {
        chop($datarec);
        if ($datarec ne '') {
            my ($userid,$password,$mailaddr,$siteurl,$username,$auth,$status,$ad1,$ad2,$ad3) = split(/\,/, $datarec);

            $ad1 =~ s/<br>/enc_crlf/g; 
            $ad2 =~ s/<br>/enc_crlf/g; 
            $ad3 =~ s/<br>/enc_crlf/g; 

            mkdir "$system_dir/user/$userid", 0777;
            my $userfile = "$system_dir/user/$userid/profile.txt";

            open my $userfh, '>', $userfile;
            print {$userfh} "$userid,$password,$mailaddr,$siteurl,$username,$auth,$status,,$ad3,$ad1,,,,\n";
            close $userfh;
        }
    }

    close $listfh;
}

# Lf[^̕ϊ
my $adfile = "$system_dir/adlink.txt";
if (-f $adfile) {

    open my $infh, '<', $adfile;
    my $datarec = <$infh>;
    chop($datarec);
    close $infh;

    if ($datarec ne '') {
        my ($ad1, $ad2, $ad3) = split(/\,/, $datarec);

        $ad1 =~ s/<br>/enc_crlf/g; 
        $ad2 =~ s/<br>/enc_crlf/g; 
        $ad3 =~ s/<br>/enc_crlf/g; 

        open my $outfh, '>', $adfile;
        print {$outfh} ",$ad3,$ad1\n";
        close $outfh;
    }
}

