#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use Lib::Logger;
use Lib::Error;
use Lib::User;
use Lib::App::Topic;
use Lib::App::Archive;
use Lib::App::Search;
use Lib::App::Bookmark;
use Lib::App::Conf;

my $logger = Lib::Logger->new();
my $error = Lib::Error->new();
my $user = Lib::User->new();
my $conf = Lib::App::Conf->new();

sub act() {
    my ($act, $cgi) = @_;

    my $sessionid = $cgi->cookie('cookie59t');
    if ($sessionid eq '') {
        $error->print_error('00003e');
    }
    my $session_userid = $user->check_session($sessionid);
    if ($session_userid eq '') {
        $error->print_error('00003e');
    }

    if (!$user->is_admin($session_userid)) {
        $error->print_error('00004e');
    }

    if ($act eq 'rebuild_content') {
        _rebuild_content();
    }
    else {
        $error->print_error('00002e');
    }
}

# HTMLファイル、RSSフィードを更新する
sub _rebuild_content() {

    # コンテンツをファイルに出力
    _output_content();

    if ($conf->get_index_rebuild()) {  # 全文検索インデックスの再構築
        my $search = Lib::App::Search->new();
        $search->rebuild();
    }

    print "Location: ./", "\n\n";
}

# RSSフィード、サイトマップ、htmlファイル等の再作成
sub _output_content {

    my $docrootdir = $conf->get_docroot_dir();
    my $systemdir = $conf->get_system_dir();
    my $datadir = $conf->get_data_dir();
    my $static_html = $conf->get_static_html();

    # 既存の月別アーカイブを全て削除
    my $dir = "$datadir/*ar.data";
    my @files = <${dir}>;
    foreach my $fname (@files) {
        unlink $fname;
    }

    my $archive = Lib::App::Archive->new();

    # RSSフィードの出力
    $archive->outputrss2();

    my $urllist = <<"END_ITEM";
    <url>
    <loc>$docrootdir/</loc>
    <changefreq>daily</changefreq>
    <priority>0.9</priority>
    </url>
END_ITEM

    my $topic = Lib::App::Topic->new();
    my $counter = $archive->get_counter();

    # トピックページ
    for my $i (0 .. $counter) {
        my $topicid = $i;
        my $ret = $topic->load($topicid, 1);
        if ($ret) {
            my $lastdate = $topic->get_lastdate();
            my $status = $topic->get_status();
            if ($status == 1 || $status == 2 || $status == 3) {
                my $htmlurl = "$docrootdir/?act=view_topic&amp;id=$topicid";
                if ($static_html) {
                    $htmlurl = "$docrootdir/detail" . "$topicid.html";
                    $topic->get_html(1, 0); # トピックHTMLファイルを更新
                }
                $archive->add_archive($topicid, $lastdate); # アーカイブデータファイルに追加
                $urllist .= <<"END_ITEM";
   <url>
    <loc>$htmlurl</loc>
    <changefreq>daily</changefreq>
    <priority>0.8</priority>
   </url>
END_ITEM
            }
            else {
                if ($static_html) {
                    my $htmlfile = "detail" . "$topicid.html";
                    unlink $htmlfile;
                }
            }
        }
    }

    # ブックマークページ
    my $bookmark = Lib::App::Bookmark->new();
    $counter = $bookmark->get_bookmark_counter();
    for my $i (1 .. $counter) {
        my $bookmarkid = $i;
        my $ret = $bookmark->load($bookmarkid, 0);
        if ($ret) {
            my $pageurl = "$docrootdir/?act=view_bookmark&amp;id=$bookmarkid";
            $urllist .= <<"END_ITEM";
   <url>
    <loc>$pageurl</loc>
    <changefreq>daily</changefreq>
    <priority>0.7</priority>
   </url>
END_ITEM
        }
    }

    open my $templatefh, '<', "$systemdir/tmpl/sitemap.tmpl";
    my $template = do { local $/; <$templatefh> };
    close $templatefh;

    $template =~ s/\$URLLIST\$/$urllist/g;

    my $sitemapfile = "sitemap.xml";
    open my $sitemapfh, '>', $sitemapfile;
    print {$sitemapfh} $template;
    close $sitemapfh;

    chmod 0766, $sitemapfile;
}

1;
