#!/usr/bin/perl
use strict;
use warnings;

# o[W̃fBNg
my $data_dir = 'data';
my $system_dir = 'system';

# gsbNf[^̕ϊ
my $counterfile = "$system_dir/topiccounter.txt";
open my $counterfh, '<', $counterfile;
my $counter = <$counterfh>;
chop $counter;
close $counterfh;

for my $i (0..$counter) {
    my $id = $i;

    # gsbNf[^
    my $datafile = "$data_dir/$id" . "tp.data";
    open my $infh, '<', $datafile;
    my $datarec = <$infh>;
    chop $datarec;
    close $infh;
    my ($topicid,$lastdate,$status,$editor,$handle,$title,$text,$commentnum,$linknum,$tbnum,$ad1,$ad2,$point) = split(/\,/, $datarec);

    # ^Of[^
    my $tagfile = "$data_dir/$id" . "tg.data";
    my $keyword = '';
    if (-f $tagfile) {
        open my $tagfh, '<', $tagfile;
        $keyword = <$tagfh>;
        chop $keyword;
        close $tagfh;
    }

    $text =~ s/<br>/<br \/>enc_crlf/g;

    $ad1 =~ s/<br>/enc_crlf/g;
    $ad2 =~ s/<br>/enc_crlf/g;

    open my $outfh, '>', $datafile;
    print {$outfh} "0,$topicid,$lastdate,$status,$editor,$handle,$title,$text,$commentnum,$linknum,$tbnum,";
    print {$outfh} ",$ad1,$ad2,$point,$keyword,\n";

    # ֘ANf[^
    my $linkfile = "$data_dir/$id" . "ln.data";
    if (-f $linkfile) {
        open my $linkfh, '<', $linkfile;
        while (my $datarec = <$linkfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($linkid,$title,$url,$summary) = split(/\,/, $datarec);
                $summary =~ s/<br>/<br \/>/g;
                if ($linkid != 0) {
                    print {$outfh} "2,$linkid,$title,$url,$summary\n";
                }
            }
        }
        close $linkfh;
    }

    # Rgf[^
    my $commentfile = "$data_dir/$id" . "cm.data";
    if (-f $commentfile) {
        open my $commentfh, '<', $commentfile;
        while (my $datarec = <$commentfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($commentid,$postdate,$author,$mailaddr,$hpurl,$commenttext,$postipaddr,$evaluate) = split(/\,/, $datarec);
                if ($commentid != 0) {
                    $commenttext =~ s/<br>/<br \/>/g;
                    print {$outfh} "3,$commentid,1,$postdate,$author,$mailaddr,$hpurl,$commenttext,$evaluate,$postipaddr\n";
                }
            }
        }
        close $commentfh;
    }

    # gbNobNf[^
    my $trackbackfile = "$data_dir/$id" . "tb.data";
    if (-f $trackbackfile) {
        open my $trackbackfh, '<', $trackbackfile;
        while (my $datarec = <$trackbackfh>) {
            chop $datarec;
            if ($datarec ne '') {
                my ($tbid,$recvdate,$url,$blogname,$entrytitle,$entryexcerpt,$tbipaddr) = split(/\,/, $datarec);
                if ($tbid != 0) {
                    print {$outfh} "4,$tbid,1,$recvdate,$url,$blogname,$entrytitle,$entryexcerpt,$tbipaddr\n";
                }
            }
        }
        close $trackbackfh;
    }

    close $outfh;
}

# L[[hfBNg̍쐬
my $keyword_dir = "$data_dir/keyword";
mkdir $keyword_dir, 0777;

# L[[hJE^[t@C̃l[
rename "$system_dir/tagcounter.txt", "$system_dir/keywordcounter.txt";

# L[[hf[^̕ϊ
my $tagfile = "$data_dir/tag/tagindex.data";
if (-f $tagfile) {
    open my $tagfh, '<', $tagfile;

    my $keywordfile = "$data_dir/keyword/keyword.data";
    open my $keywordfh, '>', $keywordfile;

    while (my $datarec = <$tagfh>) {
        chop($datarec);
        if ($datarec ne '') {
            print {$keywordfh} "$datarec,,,,,,\n";
        }
    }

    close $keywordfh;

    close $tagfh;
}

# [U[fBNg̍쐬
mkdir "$system_dir/user", 0777;

# [U[f[^̕ϊ
my $listfile = "$system_dir/userlist.txt";
if (-f $listfile) {
    open my $listfh, '<', $listfile;

    while (my $datarec = <$listfh>) {
        chop($datarec);
        if ($datarec ne '') {
            my ($userid,$password,$mailaddr,$hpurl,$username,$auth,$status,$ad1,$ad2) = split(/\,/, $datarec);

            $ad1 =~ s/<br>/enc_crlf/g; 
            $ad2 =~ s/<br>/enc_crlf/g; 

            mkdir "$system_dir/user/$userid", 0777;

            my $userfile = "$system_dir/user/$userid/profile.txt";
            open my $userfh, '>', $userfile;
            print {$userfh} "$userid,$password,$mailaddr,$hpurl,$username,$auth,$status,,$ad1,$ad2,,,,\n";
            close $userfh;
        }
    }

    close $listfh;
}

# Lf[^̕ϊ
my $adfile = "$system_dir/adlink.txt";
if (-f $adfile) {

    open my $infh, '<', $adfile;
    my $datarec = <$infh>;
    chop($datarec);
    close $infh;

    if ($datarec ne '') {
        my ($ad1, $ad2) = split(/\,/, $datarec);

        $ad1 =~ s/<br>/enc_crlf/g; 
        $ad2 =~ s/<br>/enc_crlf/g; 

        open my $outfh, '>', $adfile;
        print {$outfh} ",$ad1,$ad2\n";
        close $outfh;
    }
}

