#!/usr/bin/perl

use strict;
use warnings;

use CGI;
use Lib::App::Search;

my $cgi = CGI->new();
my $search = Lib::App::Search->new();

my $result = '';
my $target = $cgi->param('target');
if ($target ne '') {
    my $start = $cgi->param('start');
    if ($start eq '') {
        $start = 0;
    }
    if ($start == 0 && $target == 1) {
        $start++;
    }
    my $end = $cgi->param('end');
    if ($end eq '') {
        $result = $search->makeindex($target, $start);
    }
    else {
        $result = $search->makeindex($target, $start, $end);
    }
}
else {
    $search->rebuild();
}

print "Content-Type: text/html\n\n";
print "Order complete! result:$result\n";

exit;
