#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::App::Comment;

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

use Lib::DateTime;
use Lib::App::Conf;

# コンストラクタ
sub new {
    my $self = {};

    my $conf = Lib::App::Conf->new();

    $self->{data_dir} = $conf->get_data_dir();    # データディレクトリ
    $self->{comment_num} = $conf->get_comment_num();

    bless($self);
    return $self;
}

# 最近のコメントデータファイルに追加
sub add {
    my $self = shift;
    my ($topicid, $commentid, $summary) = @_;
    my @newdata = ();

    # 新規作成データを先頭に追加
    my $data = "$topicid,$commentid,$summary";
    push @newdata, $data;

    # 最近のコメントファイルを読み込み配列に保存する
    my $datafile = "$self->{data_dir}/newcomment.data";
    if (-f $datafile) {    # ファイルが存在する場合
        open my $infh, '<', $datafile;
        while (my $data = <$infh>) {
            chop $data;
            if ($data ne '') {
                push @newdata, $data;
            }
        }
        close $infh;
    }

    my $comment_num = $self->{comment_num};
    if (scalar(@newdata) > $comment_num) {
        $comment_num--;
        @newdata = @newdata[0 .. $comment_num];
    }

    open my $outfh, '>', $datafile;
    flock $outfh, LOCK_EX;
    foreach $data (@newdata) {
        print {$outfh} "$data\n";
    }
    flock $outfh, LOCK_UN;
    close $outfh;

    # ファイルのパーミッションを変更
    chmod 0766, $datafile;
}

# 最近のコメントデータファイルから削除
sub delete {
    my $self = shift;
    my ($topicid, $commentid) = @_;
    my @newdata = ();

    # 最近のコメントファイルを読み込む
    my $datafile = "$self->{data_dir}/newcomment.data";
    open my $infh, '<', $datafile;
    while (my $data = <$infh>) {
        chop $data;
        if ($data ne '') {
            my ($newtopicid, $newcommentid) = (split(/\,/, $data))[0,1];
            if (!(($newtopicid eq $topicid) && ($commentid eq $newcommentid))) {
                push @newdata, $data;
            }
        }
    }
    close $infh;

    # 最近のコメントファイルを更新
    open my $outfh, '>', $datafile;
    flock $outfh, LOCK_EX;
    foreach my $data (@newdata) {
        print {$outfh} "$data\n";
    }
    flock $outfh, LOCK_UN;
    close $outfh;
}

# 最近のコメント一覧の取得(HTML)
sub new_comment {
    my $self = shift;
    my $list = '';

    # 最近のコメントファイルを読み込みコメントを作成する
    my $datafile = "$self->{data_dir}/newcomment.data";
    if (-f $datafile) {    # ファイルが存在する場合
        open my $infh, '<', $datafile;
        while (my $data = <$infh>) {
            chop $data ; # 改行を取り除く
            if ($data ne '') {
                my ($topicid, $commentid, $summary) = split(/\,/, $data);

                # コンマをデコード
                $summary =~ s/enc_conma/,/g;

                my $topicurl = "./?act=view_topic&id=$topicid";

                # 後ろにつけていく
                $list .= <<"END_LIST";
<a href="$topicurl#comment$commentid">$summary</a><br>
END_LIST
            }
        }
        close $infh;
    }

    if ($list ne '') {
       $list = <<"END_LIST";
<div class="list">
<h5>最近のコメント</h5>
$list
</div>
<br />
END_LIST
    }

    return $list;
}

1;
# End of Comment.pm
